@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.HubPublicIPAddressesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Public IP addresses associated with azure firewall.
 * @property addresses The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
 * @property count The number of Public IP addresses associated with azure firewall.
 */
public data class HubPublicIPAddressesArgs(
    public val addresses: Output<List<AzureFirewallPublicIPAddressArgs>>? = null,
    public val count: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.HubPublicIPAddressesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.HubPublicIPAddressesArgs =
        com.pulumi.azurenative.network.inputs.HubPublicIPAddressesArgs.builder()
            .addresses(
                addresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .count(count?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HubPublicIPAddressesArgs].
 */
@PulumiTagMarker
public class HubPublicIPAddressesArgsBuilder internal constructor() {
    private var addresses: Output<List<AzureFirewallPublicIPAddressArgs>>? = null

    private var count: Output<Int>? = null

    /**
     * @param value The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
     */
    @JvmName("mlxvwgdeevchlpmr")
    public suspend fun addresses(`value`: Output<List<AzureFirewallPublicIPAddressArgs>>) {
        this.addresses = value
    }

    @JvmName("sutagmofqrhtdhgs")
    public suspend fun addresses(vararg values: Output<AzureFirewallPublicIPAddressArgs>) {
        this.addresses = Output.all(values.asList())
    }

    /**
     * @param values The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
     */
    @JvmName("gjplhibmdosukipr")
    public suspend fun addresses(values: List<Output<AzureFirewallPublicIPAddressArgs>>) {
        this.addresses = Output.all(values)
    }

    /**
     * @param value The number of Public IP addresses associated with azure firewall.
     */
    @JvmName("jnatkruwnwnddedy")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
     */
    @JvmName("ebnxbusiuxgkyxjm")
    public suspend fun addresses(`value`: List<AzureFirewallPublicIPAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addresses = mapped
    }

    /**
     * @param argument The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
     */
    @JvmName("pdylnmhwhgsrayxu")
    public suspend
    fun addresses(argument: List<suspend AzureFirewallPublicIPAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureFirewallPublicIPAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addresses = mapped
    }

    /**
     * @param argument The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
     */
    @JvmName("uijvjlunpcbgxycj")
    public suspend fun addresses(
        vararg
        argument: suspend AzureFirewallPublicIPAddressArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureFirewallPublicIPAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.addresses = mapped
    }

    /**
     * @param argument The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
     */
    @JvmName("sptdaqwrphjxprph")
    public suspend
    fun addresses(argument: suspend AzureFirewallPublicIPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureFirewallPublicIPAddressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.addresses = mapped
    }

    /**
     * @param values The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
     */
    @JvmName("rlmwndcwaxsmnfob")
    public suspend fun addresses(vararg values: AzureFirewallPublicIPAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addresses = mapped
    }

    /**
     * @param value The number of Public IP addresses associated with azure firewall.
     */
    @JvmName("kjwtekekvnvjnjtc")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    internal fun build(): HubPublicIPAddressesArgs = HubPublicIPAddressesArgs(
        addresses = addresses,
        count = count,
    )
}
