@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.IPConfigurationProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IP configuration profile child resource.
 * @property id Resource ID.
 * @property name The name of the resource. This name can be used to access the resource.
 * @property subnet The reference to the subnet resource to create a container network interface ip configuration.
 */
public data class IPConfigurationProfileArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val subnet: Output<SubnetArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.IPConfigurationProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.IPConfigurationProfileArgs =
        com.pulumi.azurenative.network.inputs.IPConfigurationProfileArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IPConfigurationProfileArgs].
 */
@PulumiTagMarker
public class IPConfigurationProfileArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var subnet: Output<SubnetArgs>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("ftufiniuninbavmb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource. This name can be used to access the resource.
     */
    @JvmName("gvwnmcmyjlbabfab")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The reference to the subnet resource to create a container network interface ip configuration.
     */
    @JvmName("dapccljomiymvdya")
    public suspend fun subnet(`value`: Output<SubnetArgs>) {
        this.subnet = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("kgrmknavawwrhybh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource. This name can be used to access the resource.
     */
    @JvmName("qtgdhxbrpcqilvpe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The reference to the subnet resource to create a container network interface ip configuration.
     */
    @JvmName("airdsoeqkrbegxeb")
    public suspend fun subnet(`value`: SubnetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument The reference to the subnet resource to create a container network interface ip configuration.
     */
    @JvmName("rcacolfgsqjneafg")
    public suspend fun subnet(argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = SubnetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): IPConfigurationProfileArgs = IPConfigurationProfileArgs(
        id = id,
        name = name,
        subnet = subnet,
    )
}
