@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.InboundNatPoolArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.TransportProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Inbound NAT pool of the load balancer.
 * @property backendPort The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
 * @property enableFloatingIP Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
 * @property enableTcpReset Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
 * @property frontendIPConfiguration A reference to frontend IP addresses.
 * @property frontendPortRangeEnd The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
 * @property frontendPortRangeStart The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
 * @property name The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be used to access the resource.
 * @property protocol The reference to the transport protocol used by the inbound NAT pool.
 */
public data class InboundNatPoolArgs(
    public val backendPort: Output<Int>,
    public val enableFloatingIP: Output<Boolean>? = null,
    public val enableTcpReset: Output<Boolean>? = null,
    public val frontendIPConfiguration: Output<SubResourceArgs>? = null,
    public val frontendPortRangeEnd: Output<Int>,
    public val frontendPortRangeStart: Output<Int>,
    public val id: Output<String>? = null,
    public val idleTimeoutInMinutes: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val protocol: Output<Either<String, TransportProtocol>>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.InboundNatPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.InboundNatPoolArgs =
        com.pulumi.azurenative.network.inputs.InboundNatPoolArgs.builder()
            .backendPort(backendPort.applyValue({ args0 -> args0 }))
            .enableFloatingIP(enableFloatingIP?.applyValue({ args0 -> args0 }))
            .enableTcpReset(enableTcpReset?.applyValue({ args0 -> args0 }))
            .frontendIPConfiguration(
                frontendIPConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .frontendPortRangeEnd(frontendPortRangeEnd.applyValue({ args0 -> args0 }))
            .frontendPortRangeStart(frontendPortRangeStart.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .idleTimeoutInMinutes(idleTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [InboundNatPoolArgs].
 */
@PulumiTagMarker
public class InboundNatPoolArgsBuilder internal constructor() {
    private var backendPort: Output<Int>? = null

    private var enableFloatingIP: Output<Boolean>? = null

    private var enableTcpReset: Output<Boolean>? = null

    private var frontendIPConfiguration: Output<SubResourceArgs>? = null

    private var frontendPortRangeEnd: Output<Int>? = null

    private var frontendPortRangeStart: Output<Int>? = null

    private var id: Output<String>? = null

    private var idleTimeoutInMinutes: Output<Int>? = null

    private var name: Output<String>? = null

    private var protocol: Output<Either<String, TransportProtocol>>? = null

    /**
     * @param value The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
     */
    @JvmName("ckfbqrmysdnehqpl")
    public suspend fun backendPort(`value`: Output<Int>) {
        this.backendPort = value
    }

    /**
     * @param value Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
     */
    @JvmName("ijuuhtnojtevxrkf")
    public suspend fun enableFloatingIP(`value`: Output<Boolean>) {
        this.enableFloatingIP = value
    }

    /**
     * @param value Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
     */
    @JvmName("dwkcdbuewhbrtxcx")
    public suspend fun enableTcpReset(`value`: Output<Boolean>) {
        this.enableTcpReset = value
    }

    /**
     * @param value A reference to frontend IP addresses.
     */
    @JvmName("doaioblmoubxwvjm")
    public suspend fun frontendIPConfiguration(`value`: Output<SubResourceArgs>) {
        this.frontendIPConfiguration = value
    }

    /**
     * @param value The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
     */
    @JvmName("ipvvniflmvckmflf")
    public suspend fun frontendPortRangeEnd(`value`: Output<Int>) {
        this.frontendPortRangeEnd = value
    }

    /**
     * @param value The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
     */
    @JvmName("fuhcbyrmasibndkb")
    public suspend fun frontendPortRangeStart(`value`: Output<Int>) {
        this.frontendPortRangeStart = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("nsproqannlpjuwbp")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
     */
    @JvmName("pcnyurfpbwmjkufs")
    public suspend fun idleTimeoutInMinutes(`value`: Output<Int>) {
        this.idleTimeoutInMinutes = value
    }

    /**
     * @param value The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("unjcbiiefrxibgqp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The reference to the transport protocol used by the inbound NAT pool.
     */
    @JvmName("mutteansgerbxxxl")
    public suspend fun protocol(`value`: Output<Either<String, TransportProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
     */
    @JvmName("cfgbryuvubvqoedj")
    public suspend fun backendPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendPort = mapped
    }

    /**
     * @param value Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
     */
    @JvmName("gvniafhsoohwfrwo")
    public suspend fun enableFloatingIP(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableFloatingIP = mapped
    }

    /**
     * @param value Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
     */
    @JvmName("nbcdehehlxpcawha")
    public suspend fun enableTcpReset(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTcpReset = mapped
    }

    /**
     * @param value A reference to frontend IP addresses.
     */
    @JvmName("nqkbukgrgbdfjjvv")
    public suspend fun frontendIPConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param argument A reference to frontend IP addresses.
     */
    @JvmName("fptcfakrydfbuqfp")
    public suspend fun frontendIPConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param value The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
     */
    @JvmName("dveorovdrpxdpncs")
    public suspend fun frontendPortRangeEnd(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendPortRangeEnd = mapped
    }

    /**
     * @param value The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
     */
    @JvmName("ronunkunvonrevah")
    public suspend fun frontendPortRangeStart(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendPortRangeStart = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("nxtittfexycpwllr")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
     */
    @JvmName("mujdtsohyjmhhvad")
    public suspend fun idleTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutInMinutes = mapped
    }

    /**
     * @param value The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("tuprfnfxrbvnfcdt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the inbound NAT pool.
     */
    @JvmName("kanodpfeavbukujy")
    public suspend fun protocol(`value`: Either<String, TransportProtocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the inbound NAT pool.
     */
    @JvmName("uckmchwitvauarqu")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The reference to the transport protocol used by the inbound NAT pool.
     */
    @JvmName("qxwvlphkqlmhbbci")
    public fun protocol(`value`: TransportProtocol) {
        val toBeMapped = Either.ofRight<String, TransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): InboundNatPoolArgs = InboundNatPoolArgs(
        backendPort = backendPort ?: throw PulumiNullFieldException("backendPort"),
        enableFloatingIP = enableFloatingIP,
        enableTcpReset = enableTcpReset,
        frontendIPConfiguration = frontendIPConfiguration,
        frontendPortRangeEnd = frontendPortRangeEnd ?: throw
            PulumiNullFieldException("frontendPortRangeEnd"),
        frontendPortRangeStart = frontendPortRangeStart ?: throw
            PulumiNullFieldException("frontendPortRangeStart"),
        id = id,
        idleTimeoutInMinutes = idleTimeoutInMinutes,
        name = name,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
    )
}
