@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.IpsecPolicyArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.DhGroup
import com.pulumi.azurenative.network.kotlin.enums.IkeEncryption
import com.pulumi.azurenative.network.kotlin.enums.IkeIntegrity
import com.pulumi.azurenative.network.kotlin.enums.IpsecEncryption
import com.pulumi.azurenative.network.kotlin.enums.IpsecIntegrity
import com.pulumi.azurenative.network.kotlin.enums.PfsGroup
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An IPSec Policy configuration for a virtual network gateway connection.
 * @property dhGroup The DH Group used in IKE Phase 1 for initial SA.
 * @property ikeEncryption The IKE encryption algorithm (IKE phase 2).
 * @property ikeIntegrity The IKE integrity algorithm (IKE phase 2).
 * @property ipsecEncryption The IPSec encryption algorithm (IKE phase 1).
 * @property ipsecIntegrity The IPSec integrity algorithm (IKE phase 1).
 * @property pfsGroup The Pfs Group used in IKE Phase 2 for new child SA.
 * @property saDataSizeKilobytes The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN tunnel.
 * @property saLifeTimeSeconds The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel.
 */
public data class IpsecPolicyArgs(
    public val dhGroup: Output<Either<String, DhGroup>>,
    public val ikeEncryption: Output<Either<String, IkeEncryption>>,
    public val ikeIntegrity: Output<Either<String, IkeIntegrity>>,
    public val ipsecEncryption: Output<Either<String, IpsecEncryption>>,
    public val ipsecIntegrity: Output<Either<String, IpsecIntegrity>>,
    public val pfsGroup: Output<Either<String, PfsGroup>>,
    public val saDataSizeKilobytes: Output<Int>,
    public val saLifeTimeSeconds: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.IpsecPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.IpsecPolicyArgs =
        com.pulumi.azurenative.network.inputs.IpsecPolicyArgs.builder()
            .dhGroup(
                dhGroup.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ikeEncryption(
                ikeEncryption.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ikeIntegrity(
                ikeIntegrity.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipsecEncryption(
                ipsecEncryption.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipsecIntegrity(
                ipsecIntegrity.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .pfsGroup(
                pfsGroup.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .saDataSizeKilobytes(saDataSizeKilobytes.applyValue({ args0 -> args0 }))
            .saLifeTimeSeconds(saLifeTimeSeconds.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpsecPolicyArgs].
 */
@PulumiTagMarker
public class IpsecPolicyArgsBuilder internal constructor() {
    private var dhGroup: Output<Either<String, DhGroup>>? = null

    private var ikeEncryption: Output<Either<String, IkeEncryption>>? = null

    private var ikeIntegrity: Output<Either<String, IkeIntegrity>>? = null

    private var ipsecEncryption: Output<Either<String, IpsecEncryption>>? = null

    private var ipsecIntegrity: Output<Either<String, IpsecIntegrity>>? = null

    private var pfsGroup: Output<Either<String, PfsGroup>>? = null

    private var saDataSizeKilobytes: Output<Int>? = null

    private var saLifeTimeSeconds: Output<Int>? = null

    /**
     * @param value The DH Group used in IKE Phase 1 for initial SA.
     */
    @JvmName("gpyhdfkmkhdwfmjw")
    public suspend fun dhGroup(`value`: Output<Either<String, DhGroup>>) {
        this.dhGroup = value
    }

    /**
     * @param value The IKE encryption algorithm (IKE phase 2).
     */
    @JvmName("bonivvuiqtdyttnc")
    public suspend fun ikeEncryption(`value`: Output<Either<String, IkeEncryption>>) {
        this.ikeEncryption = value
    }

    /**
     * @param value The IKE integrity algorithm (IKE phase 2).
     */
    @JvmName("wgtegjeawmjtwgkp")
    public suspend fun ikeIntegrity(`value`: Output<Either<String, IkeIntegrity>>) {
        this.ikeIntegrity = value
    }

    /**
     * @param value The IPSec encryption algorithm (IKE phase 1).
     */
    @JvmName("vdinogefyhtjdrum")
    public suspend fun ipsecEncryption(`value`: Output<Either<String, IpsecEncryption>>) {
        this.ipsecEncryption = value
    }

    /**
     * @param value The IPSec integrity algorithm (IKE phase 1).
     */
    @JvmName("iybukqyhldrxwoef")
    public suspend fun ipsecIntegrity(`value`: Output<Either<String, IpsecIntegrity>>) {
        this.ipsecIntegrity = value
    }

    /**
     * @param value The Pfs Group used in IKE Phase 2 for new child SA.
     */
    @JvmName("oqlwhifxhwfguhxi")
    public suspend fun pfsGroup(`value`: Output<Either<String, PfsGroup>>) {
        this.pfsGroup = value
    }

    /**
     * @param value The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN tunnel.
     */
    @JvmName("rdwomcffvxlcakcg")
    public suspend fun saDataSizeKilobytes(`value`: Output<Int>) {
        this.saDataSizeKilobytes = value
    }

    /**
     * @param value The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel.
     */
    @JvmName("gsdthgnivtdsfonp")
    public suspend fun saLifeTimeSeconds(`value`: Output<Int>) {
        this.saLifeTimeSeconds = value
    }

    /**
     * @param value The DH Group used in IKE Phase 1 for initial SA.
     */
    @JvmName("kadvvbaojetccdgq")
    public suspend fun dhGroup(`value`: Either<String, DhGroup>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dhGroup = mapped
    }

    /**
     * @param value The DH Group used in IKE Phase 1 for initial SA.
     */
    @JvmName("yfeftxlwxwbmlbgp")
    public fun dhGroup(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DhGroup>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dhGroup = mapped
    }

    /**
     * @param value The DH Group used in IKE Phase 1 for initial SA.
     */
    @JvmName("moggehvfuwyawxeo")
    public fun dhGroup(`value`: DhGroup) {
        val toBeMapped = Either.ofRight<String, DhGroup>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dhGroup = mapped
    }

    /**
     * @param value The IKE encryption algorithm (IKE phase 2).
     */
    @JvmName("trytxygrecfsttvy")
    public suspend fun ikeEncryption(`value`: Either<String, IkeEncryption>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ikeEncryption = mapped
    }

    /**
     * @param value The IKE encryption algorithm (IKE phase 2).
     */
    @JvmName("tyniwyjaturlcter")
    public fun ikeEncryption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IkeEncryption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ikeEncryption = mapped
    }

    /**
     * @param value The IKE encryption algorithm (IKE phase 2).
     */
    @JvmName("ceogcuyhbuehpqqq")
    public fun ikeEncryption(`value`: IkeEncryption) {
        val toBeMapped = Either.ofRight<String, IkeEncryption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ikeEncryption = mapped
    }

    /**
     * @param value The IKE integrity algorithm (IKE phase 2).
     */
    @JvmName("edrpfpeuctvjraau")
    public suspend fun ikeIntegrity(`value`: Either<String, IkeIntegrity>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ikeIntegrity = mapped
    }

    /**
     * @param value The IKE integrity algorithm (IKE phase 2).
     */
    @JvmName("hqynswssblxhfytd")
    public fun ikeIntegrity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IkeIntegrity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ikeIntegrity = mapped
    }

    /**
     * @param value The IKE integrity algorithm (IKE phase 2).
     */
    @JvmName("fjvtblvcbxjbtdmi")
    public fun ikeIntegrity(`value`: IkeIntegrity) {
        val toBeMapped = Either.ofRight<String, IkeIntegrity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ikeIntegrity = mapped
    }

    /**
     * @param value The IPSec encryption algorithm (IKE phase 1).
     */
    @JvmName("vdcvykibasbnvnrj")
    public suspend fun ipsecEncryption(`value`: Either<String, IpsecEncryption>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipsecEncryption = mapped
    }

    /**
     * @param value The IPSec encryption algorithm (IKE phase 1).
     */
    @JvmName("gtsokvccebctsiku")
    public fun ipsecEncryption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IpsecEncryption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipsecEncryption = mapped
    }

    /**
     * @param value The IPSec encryption algorithm (IKE phase 1).
     */
    @JvmName("umkgddamuafwtbwf")
    public fun ipsecEncryption(`value`: IpsecEncryption) {
        val toBeMapped = Either.ofRight<String, IpsecEncryption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipsecEncryption = mapped
    }

    /**
     * @param value The IPSec integrity algorithm (IKE phase 1).
     */
    @JvmName("ssxwurriunwrpccf")
    public suspend fun ipsecIntegrity(`value`: Either<String, IpsecIntegrity>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipsecIntegrity = mapped
    }

    /**
     * @param value The IPSec integrity algorithm (IKE phase 1).
     */
    @JvmName("beewybhyiowmaffh")
    public fun ipsecIntegrity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IpsecIntegrity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipsecIntegrity = mapped
    }

    /**
     * @param value The IPSec integrity algorithm (IKE phase 1).
     */
    @JvmName("nfhlixugeoajtwym")
    public fun ipsecIntegrity(`value`: IpsecIntegrity) {
        val toBeMapped = Either.ofRight<String, IpsecIntegrity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipsecIntegrity = mapped
    }

    /**
     * @param value The Pfs Group used in IKE Phase 2 for new child SA.
     */
    @JvmName("qwjatsqttoikingd")
    public suspend fun pfsGroup(`value`: Either<String, PfsGroup>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pfsGroup = mapped
    }

    /**
     * @param value The Pfs Group used in IKE Phase 2 for new child SA.
     */
    @JvmName("gicbvjhqixnaetof")
    public fun pfsGroup(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PfsGroup>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pfsGroup = mapped
    }

    /**
     * @param value The Pfs Group used in IKE Phase 2 for new child SA.
     */
    @JvmName("ppemnuxulpbfvkys")
    public fun pfsGroup(`value`: PfsGroup) {
        val toBeMapped = Either.ofRight<String, PfsGroup>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pfsGroup = mapped
    }

    /**
     * @param value The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN tunnel.
     */
    @JvmName("syhaocxfhmpfuufg")
    public suspend fun saDataSizeKilobytes(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.saDataSizeKilobytes = mapped
    }

    /**
     * @param value The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel.
     */
    @JvmName("wljypqwjmuuukkhy")
    public suspend fun saLifeTimeSeconds(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.saLifeTimeSeconds = mapped
    }

    internal fun build(): IpsecPolicyArgs = IpsecPolicyArgs(
        dhGroup = dhGroup ?: throw PulumiNullFieldException("dhGroup"),
        ikeEncryption = ikeEncryption ?: throw PulumiNullFieldException("ikeEncryption"),
        ikeIntegrity = ikeIntegrity ?: throw PulumiNullFieldException("ikeIntegrity"),
        ipsecEncryption = ipsecEncryption ?: throw PulumiNullFieldException("ipsecEncryption"),
        ipsecIntegrity = ipsecIntegrity ?: throw PulumiNullFieldException("ipsecIntegrity"),
        pfsGroup = pfsGroup ?: throw PulumiNullFieldException("pfsGroup"),
        saDataSizeKilobytes = saDataSizeKilobytes ?: throw PulumiNullFieldException("saDataSizeKilobytes"),
        saLifeTimeSeconds = saLifeTimeSeconds ?: throw PulumiNullFieldException("saLifeTimeSeconds"),
    )
}
