@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.Ipv6CircuitConnectionConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IPv6 Circuit Connection properties for global reach.
 * @property addressPrefix /125 IP address space to carve out customer addresses for global reach.
 */
public data class Ipv6CircuitConnectionConfigArgs(
    public val addressPrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.Ipv6CircuitConnectionConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.Ipv6CircuitConnectionConfigArgs =
        com.pulumi.azurenative.network.inputs.Ipv6CircuitConnectionConfigArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [Ipv6CircuitConnectionConfigArgs].
 */
@PulumiTagMarker
public class Ipv6CircuitConnectionConfigArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    /**
     * @param value /125 IP address space to carve out customer addresses for global reach.
     */
    @JvmName("lmhjqmanxwmvvksp")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value /125 IP address space to carve out customer addresses for global reach.
     */
    @JvmName("cvnmpshynjrooxpw")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    internal fun build(): Ipv6CircuitConnectionConfigArgs = Ipv6CircuitConnectionConfigArgs(
        addressPrefix = addressPrefix,
    )
}
