@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ListEffectiveVirtualNetworkByNetworkGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkGroupName The name of the network group to get.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 * @property skipToken When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
 */
public data class ListEffectiveVirtualNetworkByNetworkGroupPlainArgs(
    public val networkGroupName: String,
    public val networkManagerName: String,
    public val resourceGroupName: String,
    public val skipToken: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ListEffectiveVirtualNetworkByNetworkGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ListEffectiveVirtualNetworkByNetworkGroupPlainArgs =
        com.pulumi.azurenative.network.inputs.ListEffectiveVirtualNetworkByNetworkGroupPlainArgs.builder()
            .networkGroupName(networkGroupName.let({ args0 -> args0 }))
            .networkManagerName(networkManagerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListEffectiveVirtualNetworkByNetworkGroupPlainArgs].
 */
@PulumiTagMarker
public class ListEffectiveVirtualNetworkByNetworkGroupPlainArgsBuilder internal constructor() {
    private var networkGroupName: String? = null

    private var networkManagerName: String? = null

    private var resourceGroupName: String? = null

    private var skipToken: String? = null

    /**
     * @param value The name of the network group to get.
     */
    @JvmName("umumyhymjaafengj")
    public suspend fun networkGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkGroupName = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("gvhpakubgmchccdu")
    public suspend fun networkManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("oajjheaxkhnnoqji")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
     */
    @JvmName("cdvyngoprdhwgpon")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    internal fun build(): ListEffectiveVirtualNetworkByNetworkGroupPlainArgs =
        ListEffectiveVirtualNetworkByNetworkGroupPlainArgs(
            networkGroupName = networkGroupName ?: throw PulumiNullFieldException("networkGroupName"),
            networkManagerName = networkManagerName ?: throw PulumiNullFieldException("networkManagerName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            skipToken = skipToken,
        )
}
