@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ListNetworkManagerEffectiveConnectivityConfigurationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property skipToken When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
 * @property top An optional query parameter which specifies the maximum number of records to be returned by the server.
 * @property virtualNetworkName The name of the virtual network.
 */
public data class ListNetworkManagerEffectiveConnectivityConfigurationsPlainArgs(
    public val resourceGroupName: String,
    public val skipToken: String? = null,
    public val top: Int? = null,
    public val virtualNetworkName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ListNetworkManagerEffectiveConnectivityConfigurationsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ListNetworkManagerEffectiveConnectivityConfigurationsPlainArgs =
        com.pulumi.azurenative.network.inputs.ListNetworkManagerEffectiveConnectivityConfigurationsPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 }))
            .virtualNetworkName(virtualNetworkName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListNetworkManagerEffectiveConnectivityConfigurationsPlainArgs].
 */
@PulumiTagMarker
public class ListNetworkManagerEffectiveConnectivityConfigurationsPlainArgsBuilder internal
constructor() {
    private var resourceGroupName: String? = null

    private var skipToken: String? = null

    private var top: Int? = null

    private var virtualNetworkName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("npyilforyvpgofra")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
     */
    @JvmName("enyteldjhmenuuky")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    /**
     * @param value An optional query parameter which specifies the maximum number of records to be returned by the server.
     */
    @JvmName("jdoarjprcrjdptkd")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("vbrhbsuxtxahwgmk")
    public suspend fun virtualNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkName = mapped
    }

    internal fun build(): ListNetworkManagerEffectiveConnectivityConfigurationsPlainArgs =
        ListNetworkManagerEffectiveConnectivityConfigurationsPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            skipToken = skipToken,
            top = top,
            virtualNetworkName = virtualNetworkName ?: throw PulumiNullFieldException("virtualNetworkName"),
        )
}
