@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.LoadBalancingSettingsModelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Load balancing settings for a backend pool
 * @property additionalLatencyMilliseconds The additional latency in milliseconds for probes to fall into the lowest latency bucket
 * @property id Resource ID.
 * @property name Resource name.
 * @property sampleSize The number of samples to consider for load balancing decisions
 * @property successfulSamplesRequired The number of samples within the sample period that must succeed
 */
public data class LoadBalancingSettingsModelArgs(
    public val additionalLatencyMilliseconds: Output<Int>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val sampleSize: Output<Int>? = null,
    public val successfulSamplesRequired: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.LoadBalancingSettingsModelArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.LoadBalancingSettingsModelArgs =
        com.pulumi.azurenative.network.inputs.LoadBalancingSettingsModelArgs.builder()
            .additionalLatencyMilliseconds(additionalLatencyMilliseconds?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .sampleSize(sampleSize?.applyValue({ args0 -> args0 }))
            .successfulSamplesRequired(successfulSamplesRequired?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancingSettingsModelArgs].
 */
@PulumiTagMarker
public class LoadBalancingSettingsModelArgsBuilder internal constructor() {
    private var additionalLatencyMilliseconds: Output<Int>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var sampleSize: Output<Int>? = null

    private var successfulSamplesRequired: Output<Int>? = null

    /**
     * @param value The additional latency in milliseconds for probes to fall into the lowest latency bucket
     */
    @JvmName("arvwvngqkjoigaok")
    public suspend fun additionalLatencyMilliseconds(`value`: Output<Int>) {
        this.additionalLatencyMilliseconds = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("okdxuwmvygawayto")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource name.
     */
    @JvmName("wmqkaegvnunmjkgh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The number of samples to consider for load balancing decisions
     */
    @JvmName("whdmkdhujhjfsvgq")
    public suspend fun sampleSize(`value`: Output<Int>) {
        this.sampleSize = value
    }

    /**
     * @param value The number of samples within the sample period that must succeed
     */
    @JvmName("srtlwnuvthnqxmxb")
    public suspend fun successfulSamplesRequired(`value`: Output<Int>) {
        this.successfulSamplesRequired = value
    }

    /**
     * @param value The additional latency in milliseconds for probes to fall into the lowest latency bucket
     */
    @JvmName("sdlnkrrulawusqsw")
    public suspend fun additionalLatencyMilliseconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalLatencyMilliseconds = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("okmggqtevsrrivws")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource name.
     */
    @JvmName("xkpfoxmsshotknsx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The number of samples to consider for load balancing decisions
     */
    @JvmName("vqspccsmmlfuykpg")
    public suspend fun sampleSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sampleSize = mapped
    }

    /**
     * @param value The number of samples within the sample period that must succeed
     */
    @JvmName("qrpknmannaghhxms")
    public suspend fun successfulSamplesRequired(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successfulSamplesRequired = mapped
    }

    internal fun build(): LoadBalancingSettingsModelArgs = LoadBalancingSettingsModelArgs(
        additionalLatencyMilliseconds = additionalLatencyMilliseconds,
        id = id,
        name = name,
        sampleSize = sampleSize,
        successfulSamplesRequired = successfulSamplesRequired,
    )
}
