@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ManagedRuleOverrideArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ActionType
import com.pulumi.azurenative.network.kotlin.enums.ManagedRuleEnabledState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines a managed rule group override setting.
 * @property action Describes the override action to be applied when rule matches.
 * @property ruleId Identifier for the managed rule.
 * @property state The state of the managed rule. Defaults to Disabled if not specified.
 */
public data class ManagedRuleOverrideArgs(
    public val action: Output<Either<String, ActionType>>? = null,
    public val ruleId: Output<String>,
    public val state: Output<Either<String, ManagedRuleEnabledState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ManagedRuleOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ManagedRuleOverrideArgs =
        com.pulumi.azurenative.network.inputs.ManagedRuleOverrideArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ruleId(ruleId.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedRuleOverrideArgs].
 */
@PulumiTagMarker
public class ManagedRuleOverrideArgsBuilder internal constructor() {
    private var action: Output<Either<String, ActionType>>? = null

    private var ruleId: Output<String>? = null

    private var state: Output<Either<String, ManagedRuleEnabledState>>? = null

    /**
     * @param value Describes the override action to be applied when rule matches.
     */
    @JvmName("rdeceljeepydsdmd")
    public suspend fun action(`value`: Output<Either<String, ActionType>>) {
        this.action = value
    }

    /**
     * @param value Identifier for the managed rule.
     */
    @JvmName("jqclbcfrlascwely")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value The state of the managed rule. Defaults to Disabled if not specified.
     */
    @JvmName("nipsbnhdnrlfrsgp")
    public suspend fun state(`value`: Output<Either<String, ManagedRuleEnabledState>>) {
        this.state = value
    }

    /**
     * @param value Describes the override action to be applied when rule matches.
     */
    @JvmName("xiqpdrdbkiqmqpiq")
    public suspend fun action(`value`: Either<String, ActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes the override action to be applied when rule matches.
     */
    @JvmName("nurnwmsaapsaivww")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes the override action to be applied when rule matches.
     */
    @JvmName("cooujmckgieohmex")
    public fun action(`value`: ActionType) {
        val toBeMapped = Either.ofRight<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Identifier for the managed rule.
     */
    @JvmName("mfxjxwnnvmlhsniw")
    public suspend fun ruleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value The state of the managed rule. Defaults to Disabled if not specified.
     */
    @JvmName("xwfbrkesangqwowx")
    public suspend fun state(`value`: Either<String, ManagedRuleEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state of the managed rule. Defaults to Disabled if not specified.
     */
    @JvmName("lqtxrqgcxffgmebh")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state of the managed rule. Defaults to Disabled if not specified.
     */
    @JvmName("ofvdsdrtbdlalwar")
    public fun state(`value`: ManagedRuleEnabledState) {
        val toBeMapped = Either.ofRight<String, ManagedRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): ManagedRuleOverrideArgs = ManagedRuleOverrideArgs(
        action = action,
        ruleId = ruleId ?: throw PulumiNullFieldException("ruleId"),
        state = state,
    )
}
