@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.NatGatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Nat Gateway resource.
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The idle timeout of the nat gateway.
 * @property location Resource location.
 * @property publicIpAddresses An array of public ip addresses associated with the nat gateway resource.
 * @property publicIpPrefixes An array of public ip prefixes associated with the nat gateway resource.
 * @property sku The nat gateway SKU.
 * @property tags Resource tags.
 * @property zones A list of availability zones denoting the zone in which Nat Gateway should be deployed.
 */
public data class NatGatewayArgs(
    public val id: Output<String>? = null,
    public val idleTimeoutInMinutes: Output<Int>? = null,
    public val location: Output<String>? = null,
    public val publicIpAddresses: Output<List<SubResourceArgs>>? = null,
    public val publicIpPrefixes: Output<List<SubResourceArgs>>? = null,
    public val sku: Output<NatGatewaySkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.NatGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.NatGatewayArgs =
        com.pulumi.azurenative.network.inputs.NatGatewayArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .idleTimeoutInMinutes(idleTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .publicIpAddresses(
                publicIpAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .publicIpPrefixes(
                publicIpPrefixes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NatGatewayArgs].
 */
@PulumiTagMarker
public class NatGatewayArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var idleTimeoutInMinutes: Output<Int>? = null

    private var location: Output<String>? = null

    private var publicIpAddresses: Output<List<SubResourceArgs>>? = null

    private var publicIpPrefixes: Output<List<SubResourceArgs>>? = null

    private var sku: Output<NatGatewaySkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("ktckvfrdorbyjldv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The idle timeout of the nat gateway.
     */
    @JvmName("gncmxrpftqbdbuls")
    public suspend fun idleTimeoutInMinutes(`value`: Output<Int>) {
        this.idleTimeoutInMinutes = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("mljjgwhuddglqvxp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("ngpwowiheirlujoe")
    public suspend fun publicIpAddresses(`value`: Output<List<SubResourceArgs>>) {
        this.publicIpAddresses = value
    }

    @JvmName("nrwimoyjrawalubj")
    public suspend fun publicIpAddresses(vararg values: Output<SubResourceArgs>) {
        this.publicIpAddresses = Output.all(values.asList())
    }

    /**
     * @param values An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("bnlsggfmnonbijet")
    public suspend fun publicIpAddresses(values: List<Output<SubResourceArgs>>) {
        this.publicIpAddresses = Output.all(values)
    }

    /**
     * @param value An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("tcmpoovnnuotuqwn")
    public suspend fun publicIpPrefixes(`value`: Output<List<SubResourceArgs>>) {
        this.publicIpPrefixes = value
    }

    @JvmName("pmepiqrbmehhxiyj")
    public suspend fun publicIpPrefixes(vararg values: Output<SubResourceArgs>) {
        this.publicIpPrefixes = Output.all(values.asList())
    }

    /**
     * @param values An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("escvtcbrjcochwwf")
    public suspend fun publicIpPrefixes(values: List<Output<SubResourceArgs>>) {
        this.publicIpPrefixes = Output.all(values)
    }

    /**
     * @param value The nat gateway SKU.
     */
    @JvmName("vfxxqymvntxxvsff")
    public suspend fun sku(`value`: Output<NatGatewaySkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("awexpbgtvonhrqvq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of availability zones denoting the zone in which Nat Gateway should be deployed.
     */
    @JvmName("acxqrqncpukxpkyq")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("sqjcgyiqmcftgncc")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values A list of availability zones denoting the zone in which Nat Gateway should be deployed.
     */
    @JvmName("utnfrlxyftcdvykb")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("scgegwmlqowjrwao")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The idle timeout of the nat gateway.
     */
    @JvmName("blqdbtgkqttsiieq")
    public suspend fun idleTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutInMinutes = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xerejtvcmckignak")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("ocxkrgkfvmkrntcu")
    public suspend fun publicIpAddresses(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAddresses = mapped
    }

    /**
     * @param argument An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("jxbswuhhnftfnayv")
    public suspend fun publicIpAddresses(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.publicIpAddresses = mapped
    }

    /**
     * @param argument An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("nqtvdcqdynpvpduc")
    public suspend fun publicIpAddresses(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.publicIpAddresses = mapped
    }

    /**
     * @param argument An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("gfaqsvkfqrwyxsis")
    public suspend fun publicIpAddresses(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.publicIpAddresses = mapped
    }

    /**
     * @param values An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("ssomomxsfvkrlyuu")
    public suspend fun publicIpAddresses(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIpAddresses = mapped
    }

    /**
     * @param value An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("vyymicmjjkmiqvpf")
    public suspend fun publicIpPrefixes(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpPrefixes = mapped
    }

    /**
     * @param argument An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("qqnwcpshevlmtgnk")
    public suspend fun publicIpPrefixes(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.publicIpPrefixes = mapped
    }

    /**
     * @param argument An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("pqpkifdiolugotio")
    public suspend fun publicIpPrefixes(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.publicIpPrefixes = mapped
    }

    /**
     * @param argument An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("fggxjxgoiwstltjw")
    public suspend fun publicIpPrefixes(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.publicIpPrefixes = mapped
    }

    /**
     * @param values An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("dfeuvjibwhoyouna")
    public suspend fun publicIpPrefixes(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIpPrefixes = mapped
    }

    /**
     * @param value The nat gateway SKU.
     */
    @JvmName("kffxkskqjbdnjvhn")
    public suspend fun sku(`value`: NatGatewaySkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The nat gateway SKU.
     */
    @JvmName("kkjxuobnuhrejqqd")
    public suspend fun sku(argument: suspend NatGatewaySkuArgsBuilder.() -> Unit) {
        val toBeMapped = NatGatewaySkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("skkskopsgcsrxibw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gsqxtbetvhklamrg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of availability zones denoting the zone in which Nat Gateway should be deployed.
     */
    @JvmName("crodylekysmyseeb")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values A list of availability zones denoting the zone in which Nat Gateway should be deployed.
     */
    @JvmName("pehndohcglxjskrd")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): NatGatewayArgs = NatGatewayArgs(
        id = id,
        idleTimeoutInMinutes = idleTimeoutInMinutes,
        location = location,
        publicIpAddresses = publicIpAddresses,
        publicIpPrefixes = publicIpPrefixes,
        sku = sku,
        tags = tags,
        zones = zones,
    )
}
