@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.NetworkRuleConditionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyRuleConditionNetworkProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rule condition of type network.
 * @property description Description of the rule condition.
 * @property destinationAddresses List of destination IP addresses or Service Tags.
 * @property destinationIpGroups List of destination IpGroups for this rule.
 * @property destinationPorts List of destination ports.
 * @property ipProtocols Array of FirewallPolicyRuleConditionNetworkProtocols.
 * @property name Name of the rule condition.
 * @property ruleConditionType Rule Condition Type.
 * Expected value is 'NetworkRuleCondition'.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 */
public data class NetworkRuleConditionArgs(
    public val description: Output<String>? = null,
    public val destinationAddresses: Output<List<String>>? = null,
    public val destinationIpGroups: Output<List<String>>? = null,
    public val destinationPorts: Output<List<String>>? = null,
    public val ipProtocols: Output<List<Either<String, FirewallPolicyRuleConditionNetworkProtocol>>>? =
        null,
    public val name: Output<String>? = null,
    public val ruleConditionType: Output<String>,
    public val sourceAddresses: Output<List<String>>? = null,
    public val sourceIpGroups: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.NetworkRuleConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.NetworkRuleConditionArgs =
        com.pulumi.azurenative.network.inputs.NetworkRuleConditionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddresses(destinationAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationIpGroups(destinationIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationPorts(destinationPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipProtocols(
                ipProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .ruleConditionType(ruleConditionType.applyValue({ args0 -> args0 }))
            .sourceAddresses(sourceAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceIpGroups(sourceIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NetworkRuleConditionArgs].
 */
@PulumiTagMarker
public class NetworkRuleConditionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationAddresses: Output<List<String>>? = null

    private var destinationIpGroups: Output<List<String>>? = null

    private var destinationPorts: Output<List<String>>? = null

    private var ipProtocols: Output<List<Either<String, FirewallPolicyRuleConditionNetworkProtocol>>>? =
        null

    private var name: Output<String>? = null

    private var ruleConditionType: Output<String>? = null

    private var sourceAddresses: Output<List<String>>? = null

    private var sourceIpGroups: Output<List<String>>? = null

    /**
     * @param value Description of the rule condition.
     */
    @JvmName("cteenmqeumiuvdgg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("nlvvgptqvededbyo")
    public suspend fun destinationAddresses(`value`: Output<List<String>>) {
        this.destinationAddresses = value
    }

    @JvmName("qrhdtptcctbykhuh")
    public suspend fun destinationAddresses(vararg values: Output<String>) {
        this.destinationAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("tnvqxbnfhoalafpb")
    public suspend fun destinationAddresses(values: List<Output<String>>) {
        this.destinationAddresses = Output.all(values)
    }

    /**
     * @param value List of destination IpGroups for this rule.
     */
    @JvmName("humplnhibirujmji")
    public suspend fun destinationIpGroups(`value`: Output<List<String>>) {
        this.destinationIpGroups = value
    }

    @JvmName("pgbojiyhrmxiykrh")
    public suspend fun destinationIpGroups(vararg values: Output<String>) {
        this.destinationIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of destination IpGroups for this rule.
     */
    @JvmName("dgklnrpscmnjvaee")
    public suspend fun destinationIpGroups(values: List<Output<String>>) {
        this.destinationIpGroups = Output.all(values)
    }

    /**
     * @param value List of destination ports.
     */
    @JvmName("mxwexvthxvubdqcl")
    public suspend fun destinationPorts(`value`: Output<List<String>>) {
        this.destinationPorts = value
    }

    @JvmName("yghcmfdfasunanok")
    public suspend fun destinationPorts(vararg values: Output<String>) {
        this.destinationPorts = Output.all(values.asList())
    }

    /**
     * @param values List of destination ports.
     */
    @JvmName("vxufrymhwmithhio")
    public suspend fun destinationPorts(values: List<Output<String>>) {
        this.destinationPorts = Output.all(values)
    }

    /**
     * @param value Array of FirewallPolicyRuleConditionNetworkProtocols.
     */
    @JvmName("fqwtjqiqaehllqvy")
    public suspend
    fun ipProtocols(`value`: Output<List<Either<String, FirewallPolicyRuleConditionNetworkProtocol>>>) {
        this.ipProtocols = value
    }

    @JvmName("omqtpkliccpqjcwe")
    public suspend fun ipProtocols(
        vararg
        values: Output<Either<String, FirewallPolicyRuleConditionNetworkProtocol>>,
    ) {
        this.ipProtocols = Output.all(values.asList())
    }

    /**
     * @param values Array of FirewallPolicyRuleConditionNetworkProtocols.
     */
    @JvmName("dpvaixpuxbsjswvr")
    public suspend
    fun ipProtocols(values: List<Output<Either<String, FirewallPolicyRuleConditionNetworkProtocol>>>) {
        this.ipProtocols = Output.all(values)
    }

    /**
     * @param value Name of the rule condition.
     */
    @JvmName("tmrmojmxpumsbflf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Rule Condition Type.
     * Expected value is 'NetworkRuleCondition'.
     */
    @JvmName("efxefdyopxgihjks")
    public suspend fun ruleConditionType(`value`: Output<String>) {
        this.ruleConditionType = value
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("uhbmwopuwookjulf")
    public suspend fun sourceAddresses(`value`: Output<List<String>>) {
        this.sourceAddresses = value
    }

    @JvmName("votjkmyuxitfpvcd")
    public suspend fun sourceAddresses(vararg values: Output<String>) {
        this.sourceAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("cnfwqmetnngihkfm")
    public suspend fun sourceAddresses(values: List<Output<String>>) {
        this.sourceAddresses = Output.all(values)
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("urqeuujskmbpfmlo")
    public suspend fun sourceIpGroups(`value`: Output<List<String>>) {
        this.sourceIpGroups = value
    }

    @JvmName("lieyesfxguuasvur")
    public suspend fun sourceIpGroups(vararg values: Output<String>) {
        this.sourceIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("ixdnxecxrrqbjjum")
    public suspend fun sourceIpGroups(values: List<Output<String>>) {
        this.sourceIpGroups = Output.all(values)
    }

    /**
     * @param value Description of the rule condition.
     */
    @JvmName("mdkhnumaetcfeacu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of destination IP addresses or Service Tags.
     */
    @JvmName("njbckdscorjdbqav")
    public suspend fun destinationAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param values List of destination IP addresses or Service Tags.
     */
    @JvmName("bbyivfburrosnrrj")
    public suspend fun destinationAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param value List of destination IpGroups for this rule.
     */
    @JvmName("xxnbjqtcjksksxlf")
    public suspend fun destinationIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationIpGroups = mapped
    }

    /**
     * @param values List of destination IpGroups for this rule.
     */
    @JvmName("ybgkqlcpmttjreuu")
    public suspend fun destinationIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationIpGroups = mapped
    }

    /**
     * @param value List of destination ports.
     */
    @JvmName("gsjtiistiaeyjgqs")
    public suspend fun destinationPorts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param values List of destination ports.
     */
    @JvmName("nhvatjbtgnhxgsux")
    public suspend fun destinationPorts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param value Array of FirewallPolicyRuleConditionNetworkProtocols.
     */
    @JvmName("dywbrdtdnkmcpage")
    public suspend
    fun ipProtocols(`value`: List<Either<String, FirewallPolicyRuleConditionNetworkProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipProtocols = mapped
    }

    /**
     * @param values Array of FirewallPolicyRuleConditionNetworkProtocols.
     */
    @JvmName("yqlddslljmgfiiqu")
    public suspend fun ipProtocols(
        vararg
        values: Either<String, FirewallPolicyRuleConditionNetworkProtocol>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipProtocols = mapped
    }

    /**
     * @param value Name of the rule condition.
     */
    @JvmName("nkndmirwfdsakraj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Rule Condition Type.
     * Expected value is 'NetworkRuleCondition'.
     */
    @JvmName("aekeraylxjbvdtmu")
    public suspend fun ruleConditionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleConditionType = mapped
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("nribhjnkhfkmbrcf")
    public suspend fun sourceAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("cfytawavminxggcs")
    public suspend fun sourceAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("dugufevoegdyyycs")
    public suspend fun sourceIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("iiinimdqlgugltei")
    public suspend fun sourceIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    internal fun build(): NetworkRuleConditionArgs = NetworkRuleConditionArgs(
        description = description,
        destinationAddresses = destinationAddresses,
        destinationIpGroups = destinationIpGroups,
        destinationPorts = destinationPorts,
        ipProtocols = ipProtocols,
        name = name,
        ruleConditionType = ruleConditionType ?: throw PulumiNullFieldException("ruleConditionType"),
        sourceAddresses = sourceAddresses,
        sourceIpGroups = sourceIpGroups,
    )
}
