@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.O365BreakOutCategoryPoliciesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Office365 breakout categories.
 * @property allow Flag to control allow category.
 * @property default Flag to control default category.
 * @property optimize Flag to control optimize category.
 */
public data class O365BreakOutCategoryPoliciesArgs(
    public val allow: Output<Boolean>? = null,
    public val default: Output<Boolean>? = null,
    public val optimize: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.O365BreakOutCategoryPoliciesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.O365BreakOutCategoryPoliciesArgs =
        com.pulumi.azurenative.network.inputs.O365BreakOutCategoryPoliciesArgs.builder()
            .allow(allow?.applyValue({ args0 -> args0 }))
            .default_(default?.applyValue({ args0 -> args0 }))
            .optimize(optimize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [O365BreakOutCategoryPoliciesArgs].
 */
@PulumiTagMarker
public class O365BreakOutCategoryPoliciesArgsBuilder internal constructor() {
    private var allow: Output<Boolean>? = null

    private var default: Output<Boolean>? = null

    private var optimize: Output<Boolean>? = null

    /**
     * @param value Flag to control allow category.
     */
    @JvmName("bmtwxxjppllkdapf")
    public suspend fun allow(`value`: Output<Boolean>) {
        this.allow = value
    }

    /**
     * @param value Flag to control default category.
     */
    @JvmName("rgxrcppparitfhxp")
    public suspend fun default(`value`: Output<Boolean>) {
        this.default = value
    }

    /**
     * @param value Flag to control optimize category.
     */
    @JvmName("lyuunbqntfatymiq")
    public suspend fun optimize(`value`: Output<Boolean>) {
        this.optimize = value
    }

    /**
     * @param value Flag to control allow category.
     */
    @JvmName("hdpnensdkuyvkbsq")
    public suspend fun allow(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param value Flag to control default category.
     */
    @JvmName("xgmwdduxxesahiuo")
    public suspend fun default(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param value Flag to control optimize category.
     */
    @JvmName("uttionydwiitistj")
    public suspend fun optimize(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimize = mapped
    }

    internal fun build(): O365BreakOutCategoryPoliciesArgs = O365BreakOutCategoryPoliciesArgs(
        allow = allow,
        default = default,
        optimize = optimize,
    )
}
