@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PacketCaptureFilterArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.PcProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Filter that is applied to packet capture request. Multiple filters can be applied.
 * @property localIPAddress Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
 * @property localPort Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
 * @property protocol Protocol to be filtered on.
 * @property remoteIPAddress Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
 * @property remotePort Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
 */
public data class PacketCaptureFilterArgs(
    public val localIPAddress: Output<String>? = null,
    public val localPort: Output<String>? = null,
    public val protocol: Output<Either<String, PcProtocol>>? = null,
    public val remoteIPAddress: Output<String>? = null,
    public val remotePort: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PacketCaptureFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PacketCaptureFilterArgs =
        com.pulumi.azurenative.network.inputs.PacketCaptureFilterArgs.builder()
            .localIPAddress(localIPAddress?.applyValue({ args0 -> args0 }))
            .localPort(localPort?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .remoteIPAddress(remoteIPAddress?.applyValue({ args0 -> args0 }))
            .remotePort(remotePort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PacketCaptureFilterArgs].
 */
@PulumiTagMarker
public class PacketCaptureFilterArgsBuilder internal constructor() {
    private var localIPAddress: Output<String>? = null

    private var localPort: Output<String>? = null

    private var protocol: Output<Either<String, PcProtocol>>? = null

    private var remoteIPAddress: Output<String>? = null

    private var remotePort: Output<String>? = null

    /**
     * @param value Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
     */
    @JvmName("xvbfdrqxbaebrmqg")
    public suspend fun localIPAddress(`value`: Output<String>) {
        this.localIPAddress = value
    }

    /**
     * @param value Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
     */
    @JvmName("luicvhknaaafdlyk")
    public suspend fun localPort(`value`: Output<String>) {
        this.localPort = value
    }

    /**
     * @param value Protocol to be filtered on.
     */
    @JvmName("ayfkgsuxluubsfnv")
    public suspend fun protocol(`value`: Output<Either<String, PcProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
     */
    @JvmName("kxhxwtiiycggljef")
    public suspend fun remoteIPAddress(`value`: Output<String>) {
        this.remoteIPAddress = value
    }

    /**
     * @param value Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
     */
    @JvmName("uewjntdtejcjvovj")
    public suspend fun remotePort(`value`: Output<String>) {
        this.remotePort = value
    }

    /**
     * @param value Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
     */
    @JvmName("euvlvrojojiqqmwq")
    public suspend fun localIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localIPAddress = mapped
    }

    /**
     * @param value Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
     */
    @JvmName("pwvvulbuvhhsxyav")
    public suspend fun localPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localPort = mapped
    }

    /**
     * @param value Protocol to be filtered on.
     */
    @JvmName("vucdgpftiipevxxd")
    public suspend fun protocol(`value`: Either<String, PcProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol to be filtered on.
     */
    @JvmName("mxvheltgnivcefti")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PcProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol to be filtered on.
     */
    @JvmName("fecetxdhdohvkygr")
    public fun protocol(`value`: PcProtocol) {
        val toBeMapped = Either.ofRight<String, PcProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
     */
    @JvmName("dbqlrpnhyiihraid")
    public suspend fun remoteIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteIPAddress = mapped
    }

    /**
     * @param value Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
     */
    @JvmName("yhgywgnpaxgnrofg")
    public suspend fun remotePort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remotePort = mapped
    }

    internal fun build(): PacketCaptureFilterArgs = PacketCaptureFilterArgs(
        localIPAddress = localIPAddress,
        localPort = localPort,
        protocol = protocol,
        remoteIPAddress = remoteIPAddress,
        remotePort = remotePort,
    )
}
