@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PacketCaptureStorageLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The storage location for a packet capture session.
 * @property filePath A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
 * @property storageId The ID of the storage account to save the packet capture session. Required if no local file path is provided.
 * @property storagePath The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
 */
public data class PacketCaptureStorageLocationArgs(
    public val filePath: Output<String>? = null,
    public val storageId: Output<String>? = null,
    public val storagePath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PacketCaptureStorageLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PacketCaptureStorageLocationArgs =
        com.pulumi.azurenative.network.inputs.PacketCaptureStorageLocationArgs.builder()
            .filePath(filePath?.applyValue({ args0 -> args0 }))
            .storageId(storageId?.applyValue({ args0 -> args0 }))
            .storagePath(storagePath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PacketCaptureStorageLocationArgs].
 */
@PulumiTagMarker
public class PacketCaptureStorageLocationArgsBuilder internal constructor() {
    private var filePath: Output<String>? = null

    private var storageId: Output<String>? = null

    private var storagePath: Output<String>? = null

    /**
     * @param value A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
     */
    @JvmName("meqatsgvrjhdlbje")
    public suspend fun filePath(`value`: Output<String>) {
        this.filePath = value
    }

    /**
     * @param value The ID of the storage account to save the packet capture session. Required if no local file path is provided.
     */
    @JvmName("lvrefeqmujbneech")
    public suspend fun storageId(`value`: Output<String>) {
        this.storageId = value
    }

    /**
     * @param value The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
     */
    @JvmName("lrfjqasusqsuyjmg")
    public suspend fun storagePath(`value`: Output<String>) {
        this.storagePath = value
    }

    /**
     * @param value A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
     */
    @JvmName("iagqbacsehyfhdhy")
    public suspend fun filePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePath = mapped
    }

    /**
     * @param value The ID of the storage account to save the packet capture session. Required if no local file path is provided.
     */
    @JvmName("jnulaohyyvmogcdc")
    public suspend fun storageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageId = mapped
    }

    /**
     * @param value The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
     */
    @JvmName("pfadewhbmebjknbc")
    public suspend fun storagePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storagePath = mapped
    }

    internal fun build(): PacketCaptureStorageLocationArgs = PacketCaptureStorageLocationArgs(
        filePath = filePath,
        storageId = storageId,
        storagePath = storagePath,
    )
}
