@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Parameters for an Action.
 * @property asPath List of AS paths.
 * @property community List of BGP communities.
 * @property routePrefix List of route prefixes.
 */
public data class ParameterArgs(
    public val asPath: Output<List<String>>? = null,
    public val community: Output<List<String>>? = null,
    public val routePrefix: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ParameterArgs =
        com.pulumi.azurenative.network.inputs.ParameterArgs.builder()
            .asPath(asPath?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .community(community?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .routePrefix(routePrefix?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ParameterArgs].
 */
@PulumiTagMarker
public class ParameterArgsBuilder internal constructor() {
    private var asPath: Output<List<String>>? = null

    private var community: Output<List<String>>? = null

    private var routePrefix: Output<List<String>>? = null

    /**
     * @param value List of AS paths.
     */
    @JvmName("bmlwagkjfcvguvfb")
    public suspend fun asPath(`value`: Output<List<String>>) {
        this.asPath = value
    }

    @JvmName("wnrvkpmbfyyllvdx")
    public suspend fun asPath(vararg values: Output<String>) {
        this.asPath = Output.all(values.asList())
    }

    /**
     * @param values List of AS paths.
     */
    @JvmName("edneocisnyofcfvt")
    public suspend fun asPath(values: List<Output<String>>) {
        this.asPath = Output.all(values)
    }

    /**
     * @param value List of BGP communities.
     */
    @JvmName("mlniegxpckvdlklb")
    public suspend fun community(`value`: Output<List<String>>) {
        this.community = value
    }

    @JvmName("liseomninenotngm")
    public suspend fun community(vararg values: Output<String>) {
        this.community = Output.all(values.asList())
    }

    /**
     * @param values List of BGP communities.
     */
    @JvmName("hkbseplwygrqaiuj")
    public suspend fun community(values: List<Output<String>>) {
        this.community = Output.all(values)
    }

    /**
     * @param value List of route prefixes.
     */
    @JvmName("ahrumcqjrvgqxdeu")
    public suspend fun routePrefix(`value`: Output<List<String>>) {
        this.routePrefix = value
    }

    @JvmName("gofaepollnwfktih")
    public suspend fun routePrefix(vararg values: Output<String>) {
        this.routePrefix = Output.all(values.asList())
    }

    /**
     * @param values List of route prefixes.
     */
    @JvmName("vbseevctnjvccjym")
    public suspend fun routePrefix(values: List<Output<String>>) {
        this.routePrefix = Output.all(values)
    }

    /**
     * @param value List of AS paths.
     */
    @JvmName("cumdmjqsbhkrudks")
    public suspend fun asPath(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asPath = mapped
    }

    /**
     * @param values List of AS paths.
     */
    @JvmName("ofrmxrbxndjiuqqy")
    public suspend fun asPath(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.asPath = mapped
    }

    /**
     * @param value List of BGP communities.
     */
    @JvmName("yjmidbltqoneynex")
    public suspend fun community(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.community = mapped
    }

    /**
     * @param values List of BGP communities.
     */
    @JvmName("trrfhobgxtvkffgj")
    public suspend fun community(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.community = mapped
    }

    /**
     * @param value List of route prefixes.
     */
    @JvmName("hykkmqauirxxuywk")
    public suspend fun routePrefix(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routePrefix = mapped
    }

    /**
     * @param values List of route prefixes.
     */
    @JvmName("ydapfgvtdguohxit")
    public suspend fun routePrefix(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routePrefix = mapped
    }

    internal fun build(): ParameterArgs = ParameterArgs(
        asPath = asPath,
        community = community,
        routePrefix = routePrefix,
    )
}
