@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PolicySettingsLogScrubbingArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.WebApplicationFirewallScrubbingState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * To scrub sensitive log fields
 * @property scrubbingRules The rules that are applied to the logs for scrubbing.
 * @property state State of the log scrubbing config. Default value is Enabled.
 */
public data class PolicySettingsLogScrubbingArgs(
    public val scrubbingRules: Output<List<WebApplicationFirewallScrubbingRulesArgs>>? = null,
    public val state: Output<Either<String, WebApplicationFirewallScrubbingState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PolicySettingsLogScrubbingArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PolicySettingsLogScrubbingArgs =
        com.pulumi.azurenative.network.inputs.PolicySettingsLogScrubbingArgs.builder()
            .scrubbingRules(
                scrubbingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicySettingsLogScrubbingArgs].
 */
@PulumiTagMarker
public class PolicySettingsLogScrubbingArgsBuilder internal constructor() {
    private var scrubbingRules: Output<List<WebApplicationFirewallScrubbingRulesArgs>>? = null

    private var state: Output<Either<String, WebApplicationFirewallScrubbingState>>? = null

    /**
     * @param value The rules that are applied to the logs for scrubbing.
     */
    @JvmName("lulutgsuegdiqynm")
    public suspend
    fun scrubbingRules(`value`: Output<List<WebApplicationFirewallScrubbingRulesArgs>>) {
        this.scrubbingRules = value
    }

    @JvmName("vkpuqstxlsrdvgaw")
    public suspend fun scrubbingRules(
        vararg
        values: Output<WebApplicationFirewallScrubbingRulesArgs>,
    ) {
        this.scrubbingRules = Output.all(values.asList())
    }

    /**
     * @param values The rules that are applied to the logs for scrubbing.
     */
    @JvmName("exirhgwyhillfaem")
    public suspend
    fun scrubbingRules(values: List<Output<WebApplicationFirewallScrubbingRulesArgs>>) {
        this.scrubbingRules = Output.all(values)
    }

    /**
     * @param value State of the log scrubbing config. Default value is Enabled.
     */
    @JvmName("ggbtpykoargmvftr")
    public suspend fun state(`value`: Output<Either<String, WebApplicationFirewallScrubbingState>>) {
        this.state = value
    }

    /**
     * @param value The rules that are applied to the logs for scrubbing.
     */
    @JvmName("urtltnkcoimfydrn")
    public suspend fun scrubbingRules(`value`: List<WebApplicationFirewallScrubbingRulesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scrubbingRules = mapped
    }

    /**
     * @param argument The rules that are applied to the logs for scrubbing.
     */
    @JvmName("ulnjioswbxmxyuov")
    public suspend
    fun scrubbingRules(argument: List<suspend WebApplicationFirewallScrubbingRulesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationFirewallScrubbingRulesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scrubbingRules = mapped
    }

    /**
     * @param argument The rules that are applied to the logs for scrubbing.
     */
    @JvmName("ictnnibamcptpmuk")
    public suspend fun scrubbingRules(
        vararg
        argument: suspend WebApplicationFirewallScrubbingRulesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebApplicationFirewallScrubbingRulesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scrubbingRules = mapped
    }

    /**
     * @param argument The rules that are applied to the logs for scrubbing.
     */
    @JvmName("tyhlraamljdelekc")
    public suspend
    fun scrubbingRules(argument: suspend WebApplicationFirewallScrubbingRulesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationFirewallScrubbingRulesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.scrubbingRules = mapped
    }

    /**
     * @param values The rules that are applied to the logs for scrubbing.
     */
    @JvmName("wgncowjaispqfkrb")
    public suspend fun scrubbingRules(vararg values: WebApplicationFirewallScrubbingRulesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scrubbingRules = mapped
    }

    /**
     * @param value State of the log scrubbing config. Default value is Enabled.
     */
    @JvmName("ergymyauhnnwpkfj")
    public suspend fun state(`value`: Either<String, WebApplicationFirewallScrubbingState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of the log scrubbing config. Default value is Enabled.
     */
    @JvmName("yrokyrivbfrfavfe")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebApplicationFirewallScrubbingState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of the log scrubbing config. Default value is Enabled.
     */
    @JvmName("mcqbojqjnlsvposu")
    public fun state(`value`: WebApplicationFirewallScrubbingState) {
        val toBeMapped = Either.ofRight<String, WebApplicationFirewallScrubbingState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): PolicySettingsLogScrubbingArgs = PolicySettingsLogScrubbingArgs(
        scrubbingRules = scrubbingRules,
        state = state,
    )
}
