@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PrivateLinkServiceConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * PrivateLinkServiceConnection resource.
 * @property groupIds The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property privateLinkServiceConnectionState A collection of read-only information about the state of the connection to the remote resource.
 * @property privateLinkServiceId The resource id of private link service.
 * @property requestMessage A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
 */
public data class PrivateLinkServiceConnectionArgs(
    public val groupIds: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val privateLinkServiceId: Output<String>? = null,
    public val requestMessage: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PrivateLinkServiceConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PrivateLinkServiceConnectionArgs =
        com.pulumi.azurenative.network.inputs.PrivateLinkServiceConnectionArgs.builder()
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .privateLinkServiceId(privateLinkServiceId?.applyValue({ args0 -> args0 }))
            .requestMessage(requestMessage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionArgsBuilder internal constructor() {
    private var groupIds: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var privateLinkServiceId: Output<String>? = null

    private var requestMessage: Output<String>? = null

    /**
     * @param value The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to.
     */
    @JvmName("nqvioohgpfbgdyst")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("dfbkcnnqtvghsmsa")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to.
     */
    @JvmName("rrhnetjibcyuhdru")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ekcswhpkbvwlysoc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("rbvfiewitxynubwf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A collection of read-only information about the state of the connection to the remote resource.
     */
    @JvmName("ejplhttsmmpxibud")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The resource id of private link service.
     */
    @JvmName("evucraggkyeqvwpy")
    public suspend fun privateLinkServiceId(`value`: Output<String>) {
        this.privateLinkServiceId = value
    }

    /**
     * @param value A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
     */
    @JvmName("rwesktwvleufpnyi")
    public suspend fun requestMessage(`value`: Output<String>) {
        this.requestMessage = value
    }

    /**
     * @param value The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to.
     */
    @JvmName("yqspfbaxkjqojvad")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to.
     */
    @JvmName("kimpgxtqagipcnxq")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xccchjacakqnsmst")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("tggdtuomkfjfdros")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A collection of read-only information about the state of the connection to the remote resource.
     */
    @JvmName("kvokivgqfpxpbmaa")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of read-only information about the state of the connection to the remote resource.
     */
    @JvmName("yquyykfascrmunht")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The resource id of private link service.
     */
    @JvmName("audjbrhoabrwmweg")
    public suspend fun privateLinkServiceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceId = mapped
    }

    /**
     * @param value A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
     */
    @JvmName("qucdidmrghydsjol")
    public suspend fun requestMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMessage = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionArgs = PrivateLinkServiceConnectionArgs(
        groupIds = groupIds,
        id = id,
        name = name,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        privateLinkServiceId = privateLinkServiceId,
        requestMessage = requestMessage,
    )
}
