@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PrivateLinkServicePropertiesAutoApprovalArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The auto-approval list of the private link service.
 * @property subscriptions The list of subscriptions.
 */
public data class PrivateLinkServicePropertiesAutoApprovalArgs(
    public val subscriptions: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.PrivateLinkServicePropertiesAutoApprovalArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.PrivateLinkServicePropertiesAutoApprovalArgs =
        com.pulumi.azurenative.network.inputs.PrivateLinkServicePropertiesAutoApprovalArgs.builder()
            .subscriptions(subscriptions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PrivateLinkServicePropertiesAutoApprovalArgs].
 */
@PulumiTagMarker
public class PrivateLinkServicePropertiesAutoApprovalArgsBuilder internal constructor() {
    private var subscriptions: Output<List<String>>? = null

    /**
     * @param value The list of subscriptions.
     */
    @JvmName("nufijsuwtcwherpk")
    public suspend fun subscriptions(`value`: Output<List<String>>) {
        this.subscriptions = value
    }

    @JvmName("bhbbldwyivyhrovk")
    public suspend fun subscriptions(vararg values: Output<String>) {
        this.subscriptions = Output.all(values.asList())
    }

    /**
     * @param values The list of subscriptions.
     */
    @JvmName("iorthgbjorxfxetb")
    public suspend fun subscriptions(values: List<Output<String>>) {
        this.subscriptions = Output.all(values)
    }

    /**
     * @param value The list of subscriptions.
     */
    @JvmName("grjomekbdyvrkwna")
    public suspend fun subscriptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptions = mapped
    }

    /**
     * @param values The list of subscriptions.
     */
    @JvmName("puhjeilyqgmlnwis")
    public suspend fun subscriptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptions = mapped
    }

    internal fun build(): PrivateLinkServicePropertiesAutoApprovalArgs =
        PrivateLinkServicePropertiesAutoApprovalArgs(
            subscriptions = subscriptions,
        )
}
