@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.QosDefinitionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ProtocolType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Quality of Service defines the traffic configuration between endpoints. Mandatory to have one marking.
 * @property destinationIpRanges Destination IP ranges.
 * @property destinationPortRanges Destination port ranges.
 * @property markings List of markings to be used in the configuration.
 * @property protocol RNM supported protocol types.
 * @property sourceIpRanges Source IP ranges.
 * @property sourcePortRanges Sources port ranges.
 */
public data class QosDefinitionArgs(
    public val destinationIpRanges: Output<List<QosIpRangeArgs>>? = null,
    public val destinationPortRanges: Output<List<QosPortRangeArgs>>? = null,
    public val markings: Output<List<Int>>? = null,
    public val protocol: Output<Either<String, ProtocolType>>? = null,
    public val sourceIpRanges: Output<List<QosIpRangeArgs>>? = null,
    public val sourcePortRanges: Output<List<QosPortRangeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.QosDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.QosDefinitionArgs =
        com.pulumi.azurenative.network.inputs.QosDefinitionArgs.builder()
            .destinationIpRanges(
                destinationIpRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .destinationPortRanges(
                destinationPortRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .markings(markings?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sourceIpRanges(
                sourceIpRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourcePortRanges(
                sourcePortRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [QosDefinitionArgs].
 */
@PulumiTagMarker
public class QosDefinitionArgsBuilder internal constructor() {
    private var destinationIpRanges: Output<List<QosIpRangeArgs>>? = null

    private var destinationPortRanges: Output<List<QosPortRangeArgs>>? = null

    private var markings: Output<List<Int>>? = null

    private var protocol: Output<Either<String, ProtocolType>>? = null

    private var sourceIpRanges: Output<List<QosIpRangeArgs>>? = null

    private var sourcePortRanges: Output<List<QosPortRangeArgs>>? = null

    /**
     * @param value Destination IP ranges.
     */
    @JvmName("kmsbylqoykdhjfjs")
    public suspend fun destinationIpRanges(`value`: Output<List<QosIpRangeArgs>>) {
        this.destinationIpRanges = value
    }

    @JvmName("irvbnhjxkbrvdrsw")
    public suspend fun destinationIpRanges(vararg values: Output<QosIpRangeArgs>) {
        this.destinationIpRanges = Output.all(values.asList())
    }

    /**
     * @param values Destination IP ranges.
     */
    @JvmName("qpkxudnbdrdmvyab")
    public suspend fun destinationIpRanges(values: List<Output<QosIpRangeArgs>>) {
        this.destinationIpRanges = Output.all(values)
    }

    /**
     * @param value Destination port ranges.
     */
    @JvmName("nxhyqbejlajtvoae")
    public suspend fun destinationPortRanges(`value`: Output<List<QosPortRangeArgs>>) {
        this.destinationPortRanges = value
    }

    @JvmName("guexsganwogmhuet")
    public suspend fun destinationPortRanges(vararg values: Output<QosPortRangeArgs>) {
        this.destinationPortRanges = Output.all(values.asList())
    }

    /**
     * @param values Destination port ranges.
     */
    @JvmName("nhakwnoorcbgxfpa")
    public suspend fun destinationPortRanges(values: List<Output<QosPortRangeArgs>>) {
        this.destinationPortRanges = Output.all(values)
    }

    /**
     * @param value List of markings to be used in the configuration.
     */
    @JvmName("rqxanxaigrreopkb")
    public suspend fun markings(`value`: Output<List<Int>>) {
        this.markings = value
    }

    @JvmName("rsggwvufdynwfvxh")
    public suspend fun markings(vararg values: Output<Int>) {
        this.markings = Output.all(values.asList())
    }

    /**
     * @param values List of markings to be used in the configuration.
     */
    @JvmName("vtvgepfxuuuurxey")
    public suspend fun markings(values: List<Output<Int>>) {
        this.markings = Output.all(values)
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("wrejavwrntxmfean")
    public suspend fun protocol(`value`: Output<Either<String, ProtocolType>>) {
        this.protocol = value
    }

    /**
     * @param value Source IP ranges.
     */
    @JvmName("qprstolafobqkqui")
    public suspend fun sourceIpRanges(`value`: Output<List<QosIpRangeArgs>>) {
        this.sourceIpRanges = value
    }

    @JvmName("jqysuxovhqmuvjcn")
    public suspend fun sourceIpRanges(vararg values: Output<QosIpRangeArgs>) {
        this.sourceIpRanges = Output.all(values.asList())
    }

    /**
     * @param values Source IP ranges.
     */
    @JvmName("plmunnffsmalttxx")
    public suspend fun sourceIpRanges(values: List<Output<QosIpRangeArgs>>) {
        this.sourceIpRanges = Output.all(values)
    }

    /**
     * @param value Sources port ranges.
     */
    @JvmName("myihydbyrnaciehw")
    public suspend fun sourcePortRanges(`value`: Output<List<QosPortRangeArgs>>) {
        this.sourcePortRanges = value
    }

    @JvmName("fvytmyjoryfkkpth")
    public suspend fun sourcePortRanges(vararg values: Output<QosPortRangeArgs>) {
        this.sourcePortRanges = Output.all(values.asList())
    }

    /**
     * @param values Sources port ranges.
     */
    @JvmName("pjxlwcyntraolbwf")
    public suspend fun sourcePortRanges(values: List<Output<QosPortRangeArgs>>) {
        this.sourcePortRanges = Output.all(values)
    }

    /**
     * @param value Destination IP ranges.
     */
    @JvmName("ngkisscwbcjmpnyo")
    public suspend fun destinationIpRanges(`value`: List<QosIpRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationIpRanges = mapped
    }

    /**
     * @param argument Destination IP ranges.
     */
    @JvmName("kemqpxmlxuabdelr")
    public suspend fun destinationIpRanges(argument: List<suspend QosIpRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.destinationIpRanges = mapped
    }

    /**
     * @param argument Destination IP ranges.
     */
    @JvmName("vrhusxudxfglelgd")
    public suspend fun destinationIpRanges(
        vararg
        argument: suspend QosIpRangeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.destinationIpRanges = mapped
    }

    /**
     * @param argument Destination IP ranges.
     */
    @JvmName("wadcinqhxonvhcvn")
    public suspend fun destinationIpRanges(argument: suspend QosIpRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosIpRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinationIpRanges = mapped
    }

    /**
     * @param values Destination IP ranges.
     */
    @JvmName("vfyacobcgppohqdx")
    public suspend fun destinationIpRanges(vararg values: QosIpRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationIpRanges = mapped
    }

    /**
     * @param value Destination port ranges.
     */
    @JvmName("pfyayajhxqfpimxg")
    public suspend fun destinationPortRanges(`value`: List<QosPortRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param argument Destination port ranges.
     */
    @JvmName("ucbyrvhgvdwillhw")
    public suspend
    fun destinationPortRanges(argument: List<suspend QosPortRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationPortRanges = mapped
    }

    /**
     * @param argument Destination port ranges.
     */
    @JvmName("lvhcakfdhkgheluj")
    public suspend fun destinationPortRanges(
        vararg
        argument: suspend QosPortRangeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationPortRanges = mapped
    }

    /**
     * @param argument Destination port ranges.
     */
    @JvmName("rbigbfkgwvwucfgc")
    public suspend fun destinationPortRanges(argument: suspend QosPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosPortRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinationPortRanges = mapped
    }

    /**
     * @param values Destination port ranges.
     */
    @JvmName("wmbcsilkobmjwhuc")
    public suspend fun destinationPortRanges(vararg values: QosPortRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param value List of markings to be used in the configuration.
     */
    @JvmName("mhxajyxajdciolfa")
    public suspend fun markings(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.markings = mapped
    }

    /**
     * @param values List of markings to be used in the configuration.
     */
    @JvmName("karalfnmpncydhau")
    public suspend fun markings(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.markings = mapped
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("iyvwqdauhooqjimg")
    public suspend fun protocol(`value`: Either<String, ProtocolType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("qcxxwjfjlcptrkxp")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("xqarxyjlyketijkx")
    public fun protocol(`value`: ProtocolType) {
        val toBeMapped = Either.ofRight<String, ProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Source IP ranges.
     */
    @JvmName("rdugnbwsscmdssma")
    public suspend fun sourceIpRanges(`value`: List<QosIpRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpRanges = mapped
    }

    /**
     * @param argument Source IP ranges.
     */
    @JvmName("yccccgurvedvxsfd")
    public suspend fun sourceIpRanges(argument: List<suspend QosIpRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sourceIpRanges = mapped
    }

    /**
     * @param argument Source IP ranges.
     */
    @JvmName("dvnglyvqwuhqwxmy")
    public suspend fun sourceIpRanges(vararg argument: suspend QosIpRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sourceIpRanges = mapped
    }

    /**
     * @param argument Source IP ranges.
     */
    @JvmName("jitgeobipvjmholv")
    public suspend fun sourceIpRanges(argument: suspend QosIpRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosIpRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sourceIpRanges = mapped
    }

    /**
     * @param values Source IP ranges.
     */
    @JvmName("pwohtnxvorinnvif")
    public suspend fun sourceIpRanges(vararg values: QosIpRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpRanges = mapped
    }

    /**
     * @param value Sources port ranges.
     */
    @JvmName("ivwyglcukmhtsdtd")
    public suspend fun sourcePortRanges(`value`: List<QosPortRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param argument Sources port ranges.
     */
    @JvmName("baijvgsbyfxyvxub")
    public suspend fun sourcePortRanges(argument: List<suspend QosPortRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourcePortRanges = mapped
    }

    /**
     * @param argument Sources port ranges.
     */
    @JvmName("cccfoufmrkdlgbmt")
    public suspend fun sourcePortRanges(vararg argument: suspend QosPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourcePortRanges = mapped
    }

    /**
     * @param argument Sources port ranges.
     */
    @JvmName("wppbbieeelnvyrdh")
    public suspend fun sourcePortRanges(argument: suspend QosPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosPortRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sourcePortRanges = mapped
    }

    /**
     * @param values Sources port ranges.
     */
    @JvmName("eamnvjfxtujffjrr")
    public suspend fun sourcePortRanges(vararg values: QosPortRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    internal fun build(): QosDefinitionArgs = QosDefinitionArgs(
        destinationIpRanges = destinationIpRanges,
        destinationPortRanges = destinationPortRanges,
        markings = markings,
        protocol = protocol,
        sourceIpRanges = sourceIpRanges,
        sourcePortRanges = sourcePortRanges,
    )
}
