@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.QosPortRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Qos Traffic Profiler Port range properties.
 * @property end Qos Port Range end.
 * @property start Qos Port Range start.
 */
public data class QosPortRangeArgs(
    public val end: Output<Int>? = null,
    public val start: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.QosPortRangeArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.QosPortRangeArgs =
        com.pulumi.azurenative.network.inputs.QosPortRangeArgs.builder()
            .end(end?.applyValue({ args0 -> args0 }))
            .start(start?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QosPortRangeArgs].
 */
@PulumiTagMarker
public class QosPortRangeArgsBuilder internal constructor() {
    private var end: Output<Int>? = null

    private var start: Output<Int>? = null

    /**
     * @param value Qos Port Range end.
     */
    @JvmName("aqelvuxwqoxmyscy")
    public suspend fun end(`value`: Output<Int>) {
        this.end = value
    }

    /**
     * @param value Qos Port Range start.
     */
    @JvmName("uvafxsmsddccbevd")
    public suspend fun start(`value`: Output<Int>) {
        this.start = value
    }

    /**
     * @param value Qos Port Range end.
     */
    @JvmName("nexsxveoyvbwetth")
    public suspend fun end(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param value Qos Port Range start.
     */
    @JvmName("segtraayhuayjgbd")
    public suspend fun start(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.start = mapped
    }

    internal fun build(): QosPortRangeArgs = QosPortRangeArgs(
        end = end,
        start = start,
    )
}
