@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RoutingPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The routing policy object used in a RoutingIntent resource.
 * @property destinations List of all destinations which this routing policy is applicable to (for example: Internet, PrivateTraffic).
 * @property name The unique name for the routing policy.
 * @property nextHop The next hop resource id on which this routing policy is applicable to.
 */
public data class RoutingPolicyArgs(
    public val destinations: Output<List<String>>,
    public val name: Output<String>,
    public val nextHop: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.RoutingPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.RoutingPolicyArgs =
        com.pulumi.azurenative.network.inputs.RoutingPolicyArgs.builder()
            .destinations(destinations.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .nextHop(nextHop.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoutingPolicyArgs].
 */
@PulumiTagMarker
public class RoutingPolicyArgsBuilder internal constructor() {
    private var destinations: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var nextHop: Output<String>? = null

    /**
     * @param value List of all destinations which this routing policy is applicable to (for example: Internet, PrivateTraffic).
     */
    @JvmName("fjcokubbtkdkkrxp")
    public suspend fun destinations(`value`: Output<List<String>>) {
        this.destinations = value
    }

    @JvmName("nljhooyjqetongik")
    public suspend fun destinations(vararg values: Output<String>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values List of all destinations which this routing policy is applicable to (for example: Internet, PrivateTraffic).
     */
    @JvmName("fphycaedffhelugt")
    public suspend fun destinations(values: List<Output<String>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value The unique name for the routing policy.
     */
    @JvmName("ngujvcdyrlltpsbl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The next hop resource id on which this routing policy is applicable to.
     */
    @JvmName("artuotynqboimdpr")
    public suspend fun nextHop(`value`: Output<String>) {
        this.nextHop = value
    }

    /**
     * @param value List of all destinations which this routing policy is applicable to (for example: Internet, PrivateTraffic).
     */
    @JvmName("psfpxpueglmehujr")
    public suspend fun destinations(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param values List of all destinations which this routing policy is applicable to (for example: Internet, PrivateTraffic).
     */
    @JvmName("exkomvuowkenwyev")
    public suspend fun destinations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value The unique name for the routing policy.
     */
    @JvmName("biyyqmfwlertwpvk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The next hop resource id on which this routing policy is applicable to.
     */
    @JvmName("bxbfojsupbxgiijc")
    public suspend fun nextHop(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextHop = mapped
    }

    internal fun build(): RoutingPolicyArgs = RoutingPolicyArgs(
        destinations = destinations ?: throw PulumiNullFieldException("destinations"),
        name = name ?: throw PulumiNullFieldException("name"),
        nextHop = nextHop ?: throw PulumiNullFieldException("nextHop"),
    )
}
