@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RoutingRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FrontDoorProtocol
import com.pulumi.azurenative.network.kotlin.enums.RoutingRuleEnabledState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A routing rule represents a specification for traffic to treat and where to send it, along with health probe information.
 * @property acceptedProtocols Protocol schemes to match for this rule
 * @property enabledState Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
 * @property frontendEndpoints Frontend endpoints associated with this rule
 * @property id Resource ID.
 * @property name Resource name.
 * @property patternsToMatch The route patterns of the rule.
 * @property routeConfiguration A reference to the routing configuration.
 * @property rulesEngine A reference to a specific Rules Engine Configuration to apply to this route.
 * @property webApplicationFirewallPolicyLink Defines the Web Application Firewall policy for each routing rule (if applicable)
 */
public data class RoutingRuleArgs(
    public val acceptedProtocols: Output<List<Either<String, FrontDoorProtocol>>>? = null,
    public val enabledState: Output<Either<String, RoutingRuleEnabledState>>? = null,
    public val frontendEndpoints: Output<List<SubResourceArgs>>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val patternsToMatch: Output<List<String>>? = null,
    public val routeConfiguration:
    Output<Either<ForwardingConfigurationArgs, RedirectConfigurationArgs>>? = null,
    public val rulesEngine: Output<SubResourceArgs>? = null,
    public val webApplicationFirewallPolicyLink:
    Output<RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.RoutingRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.RoutingRuleArgs =
        com.pulumi.azurenative.network.inputs.RoutingRuleArgs.builder()
            .acceptedProtocols(
                acceptedProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .frontendEndpoints(
                frontendEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .patternsToMatch(patternsToMatch?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .routeConfiguration(
                routeConfiguration?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rulesEngine(rulesEngine?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .webApplicationFirewallPolicyLink(
                webApplicationFirewallPolicyLink?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [RoutingRuleArgs].
 */
@PulumiTagMarker
public class RoutingRuleArgsBuilder internal constructor() {
    private var acceptedProtocols: Output<List<Either<String, FrontDoorProtocol>>>? = null

    private var enabledState: Output<Either<String, RoutingRuleEnabledState>>? = null

    private var frontendEndpoints: Output<List<SubResourceArgs>>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var patternsToMatch: Output<List<String>>? = null

    private var routeConfiguration:
        Output<Either<ForwardingConfigurationArgs, RedirectConfigurationArgs>>? = null

    private var rulesEngine: Output<SubResourceArgs>? = null

    private var webApplicationFirewallPolicyLink:
        Output<RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs>? = null

    /**
     * @param value Protocol schemes to match for this rule
     */
    @JvmName("akbycuxfgkbbbfta")
    public suspend fun acceptedProtocols(`value`: Output<List<Either<String, FrontDoorProtocol>>>) {
        this.acceptedProtocols = value
    }

    @JvmName("uvxvphgvlqvbpmke")
    public suspend fun acceptedProtocols(vararg values: Output<Either<String, FrontDoorProtocol>>) {
        this.acceptedProtocols = Output.all(values.asList())
    }

    /**
     * @param values Protocol schemes to match for this rule
     */
    @JvmName("kwwvuaghxecjywno")
    public suspend fun acceptedProtocols(values: List<Output<Either<String, FrontDoorProtocol>>>) {
        this.acceptedProtocols = Output.all(values)
    }

    /**
     * @param value Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("twhbotbqrsdsvxrf")
    public suspend fun enabledState(`value`: Output<Either<String, RoutingRuleEnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value Frontend endpoints associated with this rule
     */
    @JvmName("wcxwgphmhthcsqxt")
    public suspend fun frontendEndpoints(`value`: Output<List<SubResourceArgs>>) {
        this.frontendEndpoints = value
    }

    @JvmName("vcdkkdflpgmaanyf")
    public suspend fun frontendEndpoints(vararg values: Output<SubResourceArgs>) {
        this.frontendEndpoints = Output.all(values.asList())
    }

    /**
     * @param values Frontend endpoints associated with this rule
     */
    @JvmName("ytpgcywhenvobiys")
    public suspend fun frontendEndpoints(values: List<Output<SubResourceArgs>>) {
        this.frontendEndpoints = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("vmnqdusjkfnbgsyd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource name.
     */
    @JvmName("mhximthcodxvisih")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The route patterns of the rule.
     */
    @JvmName("dcorijexcaikiyqw")
    public suspend fun patternsToMatch(`value`: Output<List<String>>) {
        this.patternsToMatch = value
    }

    @JvmName("bidjfibsjkmxypkt")
    public suspend fun patternsToMatch(vararg values: Output<String>) {
        this.patternsToMatch = Output.all(values.asList())
    }

    /**
     * @param values The route patterns of the rule.
     */
    @JvmName("ujysrqqrbgpcccfj")
    public suspend fun patternsToMatch(values: List<Output<String>>) {
        this.patternsToMatch = Output.all(values)
    }

    /**
     * @param value A reference to the routing configuration.
     */
    @JvmName("eijdkydicmuqxhly")
    public suspend
    fun routeConfiguration(`value`: Output<Either<ForwardingConfigurationArgs, RedirectConfigurationArgs>>) {
        this.routeConfiguration = value
    }

    /**
     * @param value A reference to a specific Rules Engine Configuration to apply to this route.
     */
    @JvmName("xjvvfehnntrvigbv")
    public suspend fun rulesEngine(`value`: Output<SubResourceArgs>) {
        this.rulesEngine = value
    }

    /**
     * @param value Defines the Web Application Firewall policy for each routing rule (if applicable)
     */
    @JvmName("xwapmwqwysoifdtc")
    public suspend
    fun webApplicationFirewallPolicyLink(`value`: Output<RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs>) {
        this.webApplicationFirewallPolicyLink = value
    }

    /**
     * @param value Protocol schemes to match for this rule
     */
    @JvmName("nyftkvqpuwuonfhd")
    public suspend fun acceptedProtocols(`value`: List<Either<String, FrontDoorProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptedProtocols = mapped
    }

    /**
     * @param values Protocol schemes to match for this rule
     */
    @JvmName("xvnxsilwsuqmisei")
    public suspend fun acceptedProtocols(vararg values: Either<String, FrontDoorProtocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceptedProtocols = mapped
    }

    /**
     * @param value Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("olkfoyhacqoctloq")
    public suspend fun enabledState(`value`: Either<String, RoutingRuleEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("afanusdfujfxyebj")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RoutingRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("awqoqjsbirckstqi")
    public fun enabledState(`value`: RoutingRuleEnabledState) {
        val toBeMapped = Either.ofRight<String, RoutingRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Frontend endpoints associated with this rule
     */
    @JvmName("wookjohoiumwxlee")
    public suspend fun frontendEndpoints(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendEndpoints = mapped
    }

    /**
     * @param argument Frontend endpoints associated with this rule
     */
    @JvmName("pgjjtgypxnmscslk")
    public suspend fun frontendEndpoints(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.frontendEndpoints = mapped
    }

    /**
     * @param argument Frontend endpoints associated with this rule
     */
    @JvmName("lptqvdgtawtsbael")
    public suspend fun frontendEndpoints(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.frontendEndpoints = mapped
    }

    /**
     * @param argument Frontend endpoints associated with this rule
     */
    @JvmName("pqiwothxjotbgisf")
    public suspend fun frontendEndpoints(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.frontendEndpoints = mapped
    }

    /**
     * @param values Frontend endpoints associated with this rule
     */
    @JvmName("slqrgexcjymgfgel")
    public suspend fun frontendEndpoints(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendEndpoints = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("wyrbsofxgyhtubht")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource name.
     */
    @JvmName("fctomfnfsvplirdv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The route patterns of the rule.
     */
    @JvmName("atgwkggqravqfofa")
    public suspend fun patternsToMatch(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patternsToMatch = mapped
    }

    /**
     * @param values The route patterns of the rule.
     */
    @JvmName("ttbwhpeedfaqjeca")
    public suspend fun patternsToMatch(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patternsToMatch = mapped
    }

    /**
     * @param value A reference to the routing configuration.
     */
    @JvmName("qxurifgosqpywqoh")
    public suspend
    fun routeConfiguration(`value`: Either<ForwardingConfigurationArgs, RedirectConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeConfiguration = mapped
    }

    /**
     * @param value A reference to the routing configuration.
     */
    @JvmName("xkttvsfdnookvdan")
    public fun routeConfiguration(`value`: ForwardingConfigurationArgs) {
        val toBeMapped = Either.ofLeft<ForwardingConfigurationArgs, RedirectConfigurationArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeConfiguration = mapped
    }

    /**
     * @param value A reference to the routing configuration.
     */
    @JvmName("ngbttdjltcgvhylg")
    public fun routeConfiguration(`value`: RedirectConfigurationArgs) {
        val toBeMapped = Either.ofRight<ForwardingConfigurationArgs, RedirectConfigurationArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeConfiguration = mapped
    }

    /**
     * @param value A reference to a specific Rules Engine Configuration to apply to this route.
     */
    @JvmName("ekawelnunulkmslj")
    public suspend fun rulesEngine(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rulesEngine = mapped
    }

    /**
     * @param argument A reference to a specific Rules Engine Configuration to apply to this route.
     */
    @JvmName("vjukqfrffwouhstj")
    public suspend fun rulesEngine(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rulesEngine = mapped
    }

    /**
     * @param value Defines the Web Application Firewall policy for each routing rule (if applicable)
     */
    @JvmName("qplhbablupecslne")
    public suspend
    fun webApplicationFirewallPolicyLink(`value`: RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webApplicationFirewallPolicyLink = mapped
    }

    /**
     * @param argument Defines the Web Application Firewall policy for each routing rule (if applicable)
     */
    @JvmName("pcrccbqunnpwtfip")
    public suspend
    fun webApplicationFirewallPolicyLink(argument: suspend RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgsBuilder.() -> Unit) {
        val toBeMapped =
            RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.webApplicationFirewallPolicyLink = mapped
    }

    internal fun build(): RoutingRuleArgs = RoutingRuleArgs(
        acceptedProtocols = acceptedProtocols,
        enabledState = enabledState,
        frontendEndpoints = frontendEndpoints,
        id = id,
        name = name,
        patternsToMatch = patternsToMatch,
        routeConfiguration = routeConfiguration,
        rulesEngine = rulesEngine,
        webApplicationFirewallPolicyLink = webApplicationFirewallPolicyLink,
    )
}
