@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RulesEngineMatchConditionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.RulesEngineMatchVariable
import com.pulumi.azurenative.network.kotlin.enums.RulesEngineOperator
import com.pulumi.azurenative.network.kotlin.enums.Transform
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Define a match condition
 * @property negateCondition Describes if this is negate condition or not
 * @property rulesEngineMatchValue Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
 * @property rulesEngineMatchVariable Match Variable
 * @property rulesEngineOperator Describes operator to apply to the match condition.
 * @property selector Name of selector in RequestHeader or RequestBody to be matched
 * @property transforms List of transforms
 */
public data class RulesEngineMatchConditionArgs(
    public val negateCondition: Output<Boolean>? = null,
    public val rulesEngineMatchValue: Output<List<String>>,
    public val rulesEngineMatchVariable: Output<Either<String, RulesEngineMatchVariable>>,
    public val rulesEngineOperator: Output<Either<String, RulesEngineOperator>>,
    public val selector: Output<String>? = null,
    public val transforms: Output<List<Either<String, Transform>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.RulesEngineMatchConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.RulesEngineMatchConditionArgs =
        com.pulumi.azurenative.network.inputs.RulesEngineMatchConditionArgs.builder()
            .negateCondition(negateCondition?.applyValue({ args0 -> args0 }))
            .rulesEngineMatchValue(rulesEngineMatchValue.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .rulesEngineMatchVariable(
                rulesEngineMatchVariable.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rulesEngineOperator(
                rulesEngineOperator.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .selector(selector?.applyValue({ args0 -> args0 }))
            .transforms(
                transforms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [RulesEngineMatchConditionArgs].
 */
@PulumiTagMarker
public class RulesEngineMatchConditionArgsBuilder internal constructor() {
    private var negateCondition: Output<Boolean>? = null

    private var rulesEngineMatchValue: Output<List<String>>? = null

    private var rulesEngineMatchVariable: Output<Either<String, RulesEngineMatchVariable>>? = null

    private var rulesEngineOperator: Output<Either<String, RulesEngineOperator>>? = null

    private var selector: Output<String>? = null

    private var transforms: Output<List<Either<String, Transform>>>? = null

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("nddngixfqbisauto")
    public suspend fun negateCondition(`value`: Output<Boolean>) {
        this.negateCondition = value
    }

    /**
     * @param value Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
     */
    @JvmName("badrjfvdmigpefds")
    public suspend fun rulesEngineMatchValue(`value`: Output<List<String>>) {
        this.rulesEngineMatchValue = value
    }

    @JvmName("mqcfqsamarakpeiq")
    public suspend fun rulesEngineMatchValue(vararg values: Output<String>) {
        this.rulesEngineMatchValue = Output.all(values.asList())
    }

    /**
     * @param values Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
     */
    @JvmName("sxpliiqtyanxquog")
    public suspend fun rulesEngineMatchValue(values: List<Output<String>>) {
        this.rulesEngineMatchValue = Output.all(values)
    }

    /**
     * @param value Match Variable
     */
    @JvmName("authckdgnfgmtqpm")
    public suspend
    fun rulesEngineMatchVariable(`value`: Output<Either<String, RulesEngineMatchVariable>>) {
        this.rulesEngineMatchVariable = value
    }

    /**
     * @param value Describes operator to apply to the match condition.
     */
    @JvmName("dheilkvpjsvefkyo")
    public suspend fun rulesEngineOperator(`value`: Output<Either<String, RulesEngineOperator>>) {
        this.rulesEngineOperator = value
    }

    /**
     * @param value Name of selector in RequestHeader or RequestBody to be matched
     */
    @JvmName("wdhglctokjqcoldg")
    public suspend fun selector(`value`: Output<String>) {
        this.selector = value
    }

    /**
     * @param value List of transforms
     */
    @JvmName("crgafnwqmslbgutv")
    public suspend fun transforms(`value`: Output<List<Either<String, Transform>>>) {
        this.transforms = value
    }

    @JvmName("pdqlgjgwgqetocen")
    public suspend fun transforms(vararg values: Output<Either<String, Transform>>) {
        this.transforms = Output.all(values.asList())
    }

    /**
     * @param values List of transforms
     */
    @JvmName("ejpejivtjrbcxlry")
    public suspend fun transforms(values: List<Output<Either<String, Transform>>>) {
        this.transforms = Output.all(values)
    }

    /**
     * @param value Describes if this is negate condition or not
     */
    @JvmName("usyvibjcquvlneby")
    public suspend fun negateCondition(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negateCondition = mapped
    }

    /**
     * @param value Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
     */
    @JvmName("rwlntusywoewdseo")
    public suspend fun rulesEngineMatchValue(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rulesEngineMatchValue = mapped
    }

    /**
     * @param values Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
     */
    @JvmName("acderyabaerrjxps")
    public suspend fun rulesEngineMatchValue(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rulesEngineMatchValue = mapped
    }

    /**
     * @param value Match Variable
     */
    @JvmName("emmfbgdbueauqrfp")
    public suspend fun rulesEngineMatchVariable(`value`: Either<String, RulesEngineMatchVariable>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rulesEngineMatchVariable = mapped
    }

    /**
     * @param value Match Variable
     */
    @JvmName("vdwocneugxqpfksi")
    public fun rulesEngineMatchVariable(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RulesEngineMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rulesEngineMatchVariable = mapped
    }

    /**
     * @param value Match Variable
     */
    @JvmName("tavablrsmxpyjjnt")
    public fun rulesEngineMatchVariable(`value`: RulesEngineMatchVariable) {
        val toBeMapped = Either.ofRight<String, RulesEngineMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rulesEngineMatchVariable = mapped
    }

    /**
     * @param value Describes operator to apply to the match condition.
     */
    @JvmName("nlexfjabnxmqmuvo")
    public suspend fun rulesEngineOperator(`value`: Either<String, RulesEngineOperator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rulesEngineOperator = mapped
    }

    /**
     * @param value Describes operator to apply to the match condition.
     */
    @JvmName("mvdywjqvpfpmafmd")
    public fun rulesEngineOperator(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RulesEngineOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rulesEngineOperator = mapped
    }

    /**
     * @param value Describes operator to apply to the match condition.
     */
    @JvmName("rwetbuhkhwuugnko")
    public fun rulesEngineOperator(`value`: RulesEngineOperator) {
        val toBeMapped = Either.ofRight<String, RulesEngineOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rulesEngineOperator = mapped
    }

    /**
     * @param value Name of selector in RequestHeader or RequestBody to be matched
     */
    @JvmName("hjblsgdlacculqmf")
    public suspend fun selector(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selector = mapped
    }

    /**
     * @param value List of transforms
     */
    @JvmName("tqfhecxcgoubnwfv")
    public suspend fun transforms(`value`: List<Either<String, Transform>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param values List of transforms
     */
    @JvmName("cojohknmfedccnvv")
    public suspend fun transforms(vararg values: Either<String, Transform>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    internal fun build(): RulesEngineMatchConditionArgs = RulesEngineMatchConditionArgs(
        negateCondition = negateCondition,
        rulesEngineMatchValue = rulesEngineMatchValue ?: throw
            PulumiNullFieldException("rulesEngineMatchValue"),
        rulesEngineMatchVariable = rulesEngineMatchVariable ?: throw
            PulumiNullFieldException("rulesEngineMatchVariable"),
        rulesEngineOperator = rulesEngineOperator ?: throw PulumiNullFieldException("rulesEngineOperator"),
        selector = selector,
        transforms = transforms,
    )
}
