@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.SkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The pricing tier of the web application firewall policy.
 * @property name Name of the pricing tier.
 */
public data class SkuArgs(
    public val name: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.SkuArgs =
        com.pulumi.azurenative.network.inputs.SkuArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var name: Output<Any>? = null

    /**
     * @param value Name of the pricing tier.
     */
    @JvmName("rxjqmukkpovymkjr")
    public suspend fun name(`value`: Output<Any>) {
        this.name = value
    }

    /**
     * @param value Name of the pricing tier.
     */
    @JvmName("daeuigqwvvqwuatl")
    public suspend fun name(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        name = name,
    )
}
