@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.StaticRoutesConfigArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VnetLocalRouteOverrideCriteria
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration for static routes on this HubVnetConnectionConfiguration for static routes on this HubVnetConnection.
 * @property vnetLocalRouteOverrideCriteria Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in spoke.
 */
public data class StaticRoutesConfigArgs(
    public val vnetLocalRouteOverrideCriteria: Output<Either<String, VnetLocalRouteOverrideCriteria>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.StaticRoutesConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.StaticRoutesConfigArgs =
        com.pulumi.azurenative.network.inputs.StaticRoutesConfigArgs.builder()
            .vnetLocalRouteOverrideCriteria(
                vnetLocalRouteOverrideCriteria?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [StaticRoutesConfigArgs].
 */
@PulumiTagMarker
public class StaticRoutesConfigArgsBuilder internal constructor() {
    private var vnetLocalRouteOverrideCriteria:
        Output<Either<String, VnetLocalRouteOverrideCriteria>>? = null

    /**
     * @param value Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in spoke.
     */
    @JvmName("urjxfnyfpykstluy")
    public suspend
    fun vnetLocalRouteOverrideCriteria(`value`: Output<Either<String, VnetLocalRouteOverrideCriteria>>) {
        this.vnetLocalRouteOverrideCriteria = value
    }

    /**
     * @param value Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in spoke.
     */
    @JvmName("jrkcfhhagyqaloca")
    public suspend
    fun vnetLocalRouteOverrideCriteria(`value`: Either<String, VnetLocalRouteOverrideCriteria>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetLocalRouteOverrideCriteria = mapped
    }

    /**
     * @param value Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in spoke.
     */
    @JvmName("syyoinelpwmjgryf")
    public fun vnetLocalRouteOverrideCriteria(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VnetLocalRouteOverrideCriteria>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vnetLocalRouteOverrideCriteria = mapped
    }

    /**
     * @param value Parameter determining whether NVA in spoke vnet is bypassed for traffic with destination in spoke.
     */
    @JvmName("wyuimwdssqngjptm")
    public fun vnetLocalRouteOverrideCriteria(`value`: VnetLocalRouteOverrideCriteria) {
        val toBeMapped = Either.ofRight<String, VnetLocalRouteOverrideCriteria>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vnetLocalRouteOverrideCriteria = mapped
    }

    internal fun build(): StaticRoutesConfigArgs = StaticRoutesConfigArgs(
        vnetLocalRouteOverrideCriteria = vnetLocalRouteOverrideCriteria,
    )
}
