@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.SubnetArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkPrivateEndpointNetworkPolicies
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkPrivateLinkServiceNetworkPolicies
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Subnet in a virtual network resource.
 * @property addressPrefix The address prefix for the subnet.
 * @property addressPrefixes List of address prefixes for the subnet.
 * @property applicationGatewayIPConfigurations Application gateway IP configurations of virtual network resource.
 * @property delegations An array of references to the delegations on the subnet.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ipAllocations Array of IpAllocation which reference this subnet.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property natGateway Nat gateway associated with this subnet.
 * @property networkSecurityGroup The reference to the NetworkSecurityGroup resource.
 * @property privateEndpointNetworkPolicies Enable or Disable apply network policies on private end point in the subnet.
 * @property privateLinkServiceNetworkPolicies Enable or Disable apply network policies on private link service in the subnet.
 * @property provisioningState The provisioning state of the resource.
 * @property resourceNavigationLinks Gets an array of references to the external resources using subnet.
 * @property routeTable The reference to the RouteTable resource.
 * @property serviceAssociationLinks Gets an array of references to services injecting into this subnet.
 * @property serviceEndpointPolicies An array of service endpoint policies.
 * @property serviceEndpoints An array of service endpoints.
 * @property type Resource type.
 */
public data class SubnetArgs(
    public val addressPrefix: Output<String>? = null,
    public val addressPrefixes: Output<List<String>>? = null,
    public val applicationGatewayIPConfigurations:
    Output<List<ApplicationGatewayIPConfigurationArgs>>? = null,
    public val delegations: Output<List<DelegationArgs>>? = null,
    public val etag: Output<String>? = null,
    public val id: Output<String>? = null,
    public val ipAllocations: Output<List<SubResourceArgs>>? = null,
    public val name: Output<String>? = null,
    public val natGateway: Output<SubResourceArgs>? = null,
    public val networkSecurityGroup: Output<NetworkSecurityGroupArgs>? = null,
    public val privateEndpointNetworkPolicies:
    Output<Either<String, VirtualNetworkPrivateEndpointNetworkPolicies>>? = null,
    public val privateLinkServiceNetworkPolicies:
    Output<Either<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceNavigationLinks: Output<List<ResourceNavigationLinkArgs>>? = null,
    public val routeTable: Output<RouteTableArgs>? = null,
    public val serviceAssociationLinks: Output<List<ServiceAssociationLinkArgs>>? = null,
    public val serviceEndpointPolicies: Output<List<ServiceEndpointPolicyArgs>>? = null,
    public val serviceEndpoints: Output<List<ServiceEndpointPropertiesFormatArgs>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.SubnetArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.SubnetArgs =
        com.pulumi.azurenative.network.inputs.SubnetArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .addressPrefixes(addressPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .applicationGatewayIPConfigurations(
                applicationGatewayIPConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .delegations(
                delegations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .etag(etag?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipAllocations(
                ipAllocations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .natGateway(natGateway?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkSecurityGroup(
                networkSecurityGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .privateEndpointNetworkPolicies(
                privateEndpointNetworkPolicies?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateLinkServiceNetworkPolicies(
                privateLinkServiceNetworkPolicies?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceNavigationLinks(
                resourceNavigationLinks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .routeTable(routeTable?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceAssociationLinks(
                serviceAssociationLinks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceEndpointPolicies(
                serviceEndpointPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceEndpoints(
                serviceEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetArgs].
 */
@PulumiTagMarker
public class SubnetArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var addressPrefixes: Output<List<String>>? = null

    private var applicationGatewayIPConfigurations:
        Output<List<ApplicationGatewayIPConfigurationArgs>>? = null

    private var delegations: Output<List<DelegationArgs>>? = null

    private var etag: Output<String>? = null

    private var id: Output<String>? = null

    private var ipAllocations: Output<List<SubResourceArgs>>? = null

    private var name: Output<String>? = null

    private var natGateway: Output<SubResourceArgs>? = null

    private var networkSecurityGroup: Output<NetworkSecurityGroupArgs>? = null

    private var privateEndpointNetworkPolicies:
        Output<Either<String, VirtualNetworkPrivateEndpointNetworkPolicies>>? = null

    private var privateLinkServiceNetworkPolicies:
        Output<Either<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>>? = null

    private var provisioningState: Output<String>? = null

    private var resourceNavigationLinks: Output<List<ResourceNavigationLinkArgs>>? = null

    private var routeTable: Output<RouteTableArgs>? = null

    private var serviceAssociationLinks: Output<List<ServiceAssociationLinkArgs>>? = null

    private var serviceEndpointPolicies: Output<List<ServiceEndpointPolicyArgs>>? = null

    private var serviceEndpoints: Output<List<ServiceEndpointPropertiesFormatArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The address prefix for the subnet.
     */
    @JvmName("tkmyyfounqknvdpe")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value List of address prefixes for the subnet.
     */
    @JvmName("eltwurrvrbjjtsep")
    public suspend fun addressPrefixes(`value`: Output<List<String>>) {
        this.addressPrefixes = value
    }

    @JvmName("lipwqvyjehcxvjyl")
    public suspend fun addressPrefixes(vararg values: Output<String>) {
        this.addressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values List of address prefixes for the subnet.
     */
    @JvmName("kppkkjfnhebkhprg")
    public suspend fun addressPrefixes(values: List<Output<String>>) {
        this.addressPrefixes = Output.all(values)
    }

    /**
     * @param value Application gateway IP configurations of virtual network resource.
     */
    @JvmName("cwhmtaqrtbvlvyhx")
    public suspend
    fun applicationGatewayIPConfigurations(`value`: Output<List<ApplicationGatewayIPConfigurationArgs>>) {
        this.applicationGatewayIPConfigurations = value
    }

    @JvmName("siknmrjtiqbbdbga")
    public suspend fun applicationGatewayIPConfigurations(
        vararg
        values: Output<ApplicationGatewayIPConfigurationArgs>,
    ) {
        this.applicationGatewayIPConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Application gateway IP configurations of virtual network resource.
     */
    @JvmName("rpvcicftcmxjjiet")
    public suspend
    fun applicationGatewayIPConfigurations(values: List<Output<ApplicationGatewayIPConfigurationArgs>>) {
        this.applicationGatewayIPConfigurations = Output.all(values)
    }

    /**
     * @param value An array of references to the delegations on the subnet.
     */
    @JvmName("fnlemwshrxbqpdim")
    public suspend fun delegations(`value`: Output<List<DelegationArgs>>) {
        this.delegations = value
    }

    @JvmName("swgckysrifoqlrfp")
    public suspend fun delegations(vararg values: Output<DelegationArgs>) {
        this.delegations = Output.all(values.asList())
    }

    /**
     * @param values An array of references to the delegations on the subnet.
     */
    @JvmName("daqyqwijrtsorirq")
    public suspend fun delegations(values: List<Output<DelegationArgs>>) {
        this.delegations = Output.all(values)
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("lpkouacxrnaurcgt")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("avplyrdmnnqqpugk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Array of IpAllocation which reference this subnet.
     */
    @JvmName("xjltqjqewnslnsgo")
    public suspend fun ipAllocations(`value`: Output<List<SubResourceArgs>>) {
        this.ipAllocations = value
    }

    @JvmName("upbnuejcothpccrx")
    public suspend fun ipAllocations(vararg values: Output<SubResourceArgs>) {
        this.ipAllocations = Output.all(values.asList())
    }

    /**
     * @param values Array of IpAllocation which reference this subnet.
     */
    @JvmName("euqyvdolynhowsgb")
    public suspend fun ipAllocations(values: List<Output<SubResourceArgs>>) {
        this.ipAllocations = Output.all(values)
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("urohivtuvoyoeoft")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Nat gateway associated with this subnet.
     */
    @JvmName("pydlihofcgvtwyqp")
    public suspend fun natGateway(`value`: Output<SubResourceArgs>) {
        this.natGateway = value
    }

    /**
     * @param value The reference to the NetworkSecurityGroup resource.
     */
    @JvmName("pdsahjqwxdntadjy")
    public suspend fun networkSecurityGroup(`value`: Output<NetworkSecurityGroupArgs>) {
        this.networkSecurityGroup = value
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("etokbcxqojuhurlj")
    public suspend
    fun privateEndpointNetworkPolicies(`value`: Output<Either<String, VirtualNetworkPrivateEndpointNetworkPolicies>>) {
        this.privateEndpointNetworkPolicies = value
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("egwwjfcqchjeedmc")
    public suspend
    fun privateLinkServiceNetworkPolicies(`value`: Output<Either<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>>) {
        this.privateLinkServiceNetworkPolicies = value
    }

    /**
     * @param value The provisioning state of the resource.
     */
    @JvmName("jqjjtbayurqikxvg")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value Gets an array of references to the external resources using subnet.
     */
    @JvmName("wlevbnxvfmnmbcni")
    public suspend fun resourceNavigationLinks(`value`: Output<List<ResourceNavigationLinkArgs>>) {
        this.resourceNavigationLinks = value
    }

    @JvmName("ypjsnohimxfxowsm")
    public suspend fun resourceNavigationLinks(vararg values: Output<ResourceNavigationLinkArgs>) {
        this.resourceNavigationLinks = Output.all(values.asList())
    }

    /**
     * @param values Gets an array of references to the external resources using subnet.
     */
    @JvmName("xjlqiijxdihiqabi")
    public suspend fun resourceNavigationLinks(values: List<Output<ResourceNavigationLinkArgs>>) {
        this.resourceNavigationLinks = Output.all(values)
    }

    /**
     * @param value The reference to the RouteTable resource.
     */
    @JvmName("avuynlugwbchnqau")
    public suspend fun routeTable(`value`: Output<RouteTableArgs>) {
        this.routeTable = value
    }

    /**
     * @param value Gets an array of references to services injecting into this subnet.
     */
    @JvmName("ulmtgqyxxabserqt")
    public suspend fun serviceAssociationLinks(`value`: Output<List<ServiceAssociationLinkArgs>>) {
        this.serviceAssociationLinks = value
    }

    @JvmName("fhmuesjhejlywugn")
    public suspend fun serviceAssociationLinks(vararg values: Output<ServiceAssociationLinkArgs>) {
        this.serviceAssociationLinks = Output.all(values.asList())
    }

    /**
     * @param values Gets an array of references to services injecting into this subnet.
     */
    @JvmName("erbdajmbuyxemiie")
    public suspend fun serviceAssociationLinks(values: List<Output<ServiceAssociationLinkArgs>>) {
        this.serviceAssociationLinks = Output.all(values)
    }

    /**
     * @param value An array of service endpoint policies.
     */
    @JvmName("hiygbdkiporgptns")
    public suspend fun serviceEndpointPolicies(`value`: Output<List<ServiceEndpointPolicyArgs>>) {
        this.serviceEndpointPolicies = value
    }

    @JvmName("obufrmucowomhtao")
    public suspend fun serviceEndpointPolicies(vararg values: Output<ServiceEndpointPolicyArgs>) {
        this.serviceEndpointPolicies = Output.all(values.asList())
    }

    /**
     * @param values An array of service endpoint policies.
     */
    @JvmName("vsvfvdpuqdpdqmml")
    public suspend fun serviceEndpointPolicies(values: List<Output<ServiceEndpointPolicyArgs>>) {
        this.serviceEndpointPolicies = Output.all(values)
    }

    /**
     * @param value An array of service endpoints.
     */
    @JvmName("enngskhpoibekpcr")
    public suspend fun serviceEndpoints(`value`: Output<List<ServiceEndpointPropertiesFormatArgs>>) {
        this.serviceEndpoints = value
    }

    @JvmName("wbewefyjtbrdkwyo")
    public suspend fun serviceEndpoints(vararg values: Output<ServiceEndpointPropertiesFormatArgs>) {
        this.serviceEndpoints = Output.all(values.asList())
    }

    /**
     * @param values An array of service endpoints.
     */
    @JvmName("vgnfpbytlatsvfju")
    public suspend fun serviceEndpoints(values: List<Output<ServiceEndpointPropertiesFormatArgs>>) {
        this.serviceEndpoints = Output.all(values)
    }

    /**
     * @param value Resource type.
     */
    @JvmName("ekogwxohrtlwaihg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The address prefix for the subnet.
     */
    @JvmName("xiyfoepkuqcpnaxf")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value List of address prefixes for the subnet.
     */
    @JvmName("tujweemeuevvdxij")
    public suspend fun addressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param values List of address prefixes for the subnet.
     */
    @JvmName("mqonubhyjhbfofdl")
    public suspend fun addressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param value Application gateway IP configurations of virtual network resource.
     */
    @JvmName("llkxyspfjjjeebiu")
    public suspend
    fun applicationGatewayIPConfigurations(`value`: List<ApplicationGatewayIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param argument Application gateway IP configurations of virtual network resource.
     */
    @JvmName("gahxertwdkwapiyp")
    public suspend
    fun applicationGatewayIPConfigurations(argument: List<suspend ApplicationGatewayIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param argument Application gateway IP configurations of virtual network resource.
     */
    @JvmName("kgauyksmkkvnkvtu")
    public suspend fun applicationGatewayIPConfigurations(
        vararg
        argument: suspend ApplicationGatewayIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param argument Application gateway IP configurations of virtual network resource.
     */
    @JvmName("epbysdjhkjrdfmpq")
    public suspend
    fun applicationGatewayIPConfigurations(argument: suspend ApplicationGatewayIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param values Application gateway IP configurations of virtual network resource.
     */
    @JvmName("ewaypxongrujuerg")
    public suspend fun applicationGatewayIPConfigurations(
        vararg
        values: ApplicationGatewayIPConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param value An array of references to the delegations on the subnet.
     */
    @JvmName("hcjlfxtaimvriyiw")
    public suspend fun delegations(`value`: List<DelegationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delegations = mapped
    }

    /**
     * @param argument An array of references to the delegations on the subnet.
     */
    @JvmName("oubwgmlqopaqvosf")
    public suspend fun delegations(argument: List<suspend DelegationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DelegationArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.delegations = mapped
    }

    /**
     * @param argument An array of references to the delegations on the subnet.
     */
    @JvmName("xrxmqodtuaypunxq")
    public suspend fun delegations(vararg argument: suspend DelegationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DelegationArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.delegations = mapped
    }

    /**
     * @param argument An array of references to the delegations on the subnet.
     */
    @JvmName("vhgquncytaxdgtuj")
    public suspend fun delegations(argument: suspend DelegationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DelegationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.delegations = mapped
    }

    /**
     * @param values An array of references to the delegations on the subnet.
     */
    @JvmName("kdiodeoljeniphma")
    public suspend fun delegations(vararg values: DelegationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.delegations = mapped
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("tdjkxfkgboncxqte")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("uahantwbpxiathci")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Array of IpAllocation which reference this subnet.
     */
    @JvmName("enhgdfdvrolocwia")
    public suspend fun ipAllocations(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAllocations = mapped
    }

    /**
     * @param argument Array of IpAllocation which reference this subnet.
     */
    @JvmName("qyifwhkpyqnuhmwc")
    public suspend fun ipAllocations(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipAllocations = mapped
    }

    /**
     * @param argument Array of IpAllocation which reference this subnet.
     */
    @JvmName("twdolvhwvdjkjmph")
    public suspend fun ipAllocations(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipAllocations = mapped
    }

    /**
     * @param argument Array of IpAllocation which reference this subnet.
     */
    @JvmName("eprameaqtbksegwi")
    public suspend fun ipAllocations(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipAllocations = mapped
    }

    /**
     * @param values Array of IpAllocation which reference this subnet.
     */
    @JvmName("vxodmtpoagqnkgov")
    public suspend fun ipAllocations(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocations = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("kswojhasljpsgtmu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Nat gateway associated with this subnet.
     */
    @JvmName("pdofuskdrxqwxisf")
    public suspend fun natGateway(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGateway = mapped
    }

    /**
     * @param argument Nat gateway associated with this subnet.
     */
    @JvmName("hpyxrpvmdcfelgvl")
    public suspend fun natGateway(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.natGateway = mapped
    }

    /**
     * @param value The reference to the NetworkSecurityGroup resource.
     */
    @JvmName("ntcktyrkuyxrcwph")
    public suspend fun networkSecurityGroup(`value`: NetworkSecurityGroupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityGroup = mapped
    }

    /**
     * @param argument The reference to the NetworkSecurityGroup resource.
     */
    @JvmName("mtqdmcuagealujcd")
    public suspend
    fun networkSecurityGroup(argument: suspend NetworkSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkSecurityGroupArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkSecurityGroup = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("ipivuogfrlbdlvcp")
    public suspend
    fun privateEndpointNetworkPolicies(`value`: Either<String, VirtualNetworkPrivateEndpointNetworkPolicies>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("rvlafupitmaucogn")
    public fun privateEndpointNetworkPolicies(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkPrivateEndpointNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("cjsvkapatvxtajck")
    public fun privateEndpointNetworkPolicies(`value`: VirtualNetworkPrivateEndpointNetworkPolicies) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkPrivateEndpointNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("nltyipmcqkqkjldb")
    public suspend
    fun privateLinkServiceNetworkPolicies(`value`: Either<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("msnjjrryfucfryss")
    public fun privateLinkServiceNetworkPolicies(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("vpstdytnrvjoobrh")
    public
    fun privateLinkServiceNetworkPolicies(`value`: VirtualNetworkPrivateLinkServiceNetworkPolicies) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceNetworkPolicies = mapped
    }

    /**
     * @param value The provisioning state of the resource.
     */
    @JvmName("drdvpjujfesbmcye")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Gets an array of references to the external resources using subnet.
     */
    @JvmName("nfmqndggypjucfhj")
    public suspend fun resourceNavigationLinks(`value`: List<ResourceNavigationLinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceNavigationLinks = mapped
    }

    /**
     * @param argument Gets an array of references to the external resources using subnet.
     */
    @JvmName("knslsgljtjuwbrts")
    public suspend
    fun resourceNavigationLinks(argument: List<suspend ResourceNavigationLinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceNavigationLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceNavigationLinks = mapped
    }

    /**
     * @param argument Gets an array of references to the external resources using subnet.
     */
    @JvmName("tpgekiepatiiwgrd")
    public suspend fun resourceNavigationLinks(
        vararg
        argument: suspend ResourceNavigationLinkArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceNavigationLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceNavigationLinks = mapped
    }

    /**
     * @param argument Gets an array of references to the external resources using subnet.
     */
    @JvmName("soejujmelnneabsn")
    public suspend
    fun resourceNavigationLinks(argument: suspend ResourceNavigationLinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceNavigationLinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.resourceNavigationLinks = mapped
    }

    /**
     * @param values Gets an array of references to the external resources using subnet.
     */
    @JvmName("vtojgtwbknrsgyal")
    public suspend fun resourceNavigationLinks(vararg values: ResourceNavigationLinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceNavigationLinks = mapped
    }

    /**
     * @param value The reference to the RouteTable resource.
     */
    @JvmName("bdgjrhbhmjhqcgdk")
    public suspend fun routeTable(`value`: RouteTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTable = mapped
    }

    /**
     * @param argument The reference to the RouteTable resource.
     */
    @JvmName("vdfyftwheojmsmts")
    public suspend fun routeTable(argument: suspend RouteTableArgsBuilder.() -> Unit) {
        val toBeMapped = RouteTableArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routeTable = mapped
    }

    /**
     * @param value Gets an array of references to services injecting into this subnet.
     */
    @JvmName("gujkmekufdoyydfy")
    public suspend fun serviceAssociationLinks(`value`: List<ServiceAssociationLinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAssociationLinks = mapped
    }

    /**
     * @param argument Gets an array of references to services injecting into this subnet.
     */
    @JvmName("jytfwvlcvnkcmdwe")
    public suspend
    fun serviceAssociationLinks(argument: List<suspend ServiceAssociationLinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceAssociationLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceAssociationLinks = mapped
    }

    /**
     * @param argument Gets an array of references to services injecting into this subnet.
     */
    @JvmName("uxknmpbjxnqnopea")
    public suspend fun serviceAssociationLinks(
        vararg
        argument: suspend ServiceAssociationLinkArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceAssociationLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceAssociationLinks = mapped
    }

    /**
     * @param argument Gets an array of references to services injecting into this subnet.
     */
    @JvmName("gcebujyusiqonumy")
    public suspend
    fun serviceAssociationLinks(argument: suspend ServiceAssociationLinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceAssociationLinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.serviceAssociationLinks = mapped
    }

    /**
     * @param values Gets an array of references to services injecting into this subnet.
     */
    @JvmName("hwcuohvoiyghurgv")
    public suspend fun serviceAssociationLinks(vararg values: ServiceAssociationLinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceAssociationLinks = mapped
    }

    /**
     * @param value An array of service endpoint policies.
     */
    @JvmName("jrhavfbgiurpgcyu")
    public suspend fun serviceEndpointPolicies(`value`: List<ServiceEndpointPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param argument An array of service endpoint policies.
     */
    @JvmName("kuinmqigyncveggk")
    public suspend
    fun serviceEndpointPolicies(argument: List<suspend ServiceEndpointPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param argument An array of service endpoint policies.
     */
    @JvmName("nissnscryciikqnx")
    public suspend fun serviceEndpointPolicies(
        vararg
        argument: suspend ServiceEndpointPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param argument An array of service endpoint policies.
     */
    @JvmName("cdnfqtlwcyxgogky")
    public suspend
    fun serviceEndpointPolicies(argument: suspend ServiceEndpointPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceEndpointPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param values An array of service endpoint policies.
     */
    @JvmName("ehwbgqcjfnyxcjiy")
    public suspend fun serviceEndpointPolicies(vararg values: ServiceEndpointPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param value An array of service endpoints.
     */
    @JvmName("pbxcxyvcbecbhvmw")
    public suspend fun serviceEndpoints(`value`: List<ServiceEndpointPropertiesFormatArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpoints = mapped
    }

    /**
     * @param argument An array of service endpoints.
     */
    @JvmName("tgcajonweimhmrwb")
    public suspend
    fun serviceEndpoints(argument: List<suspend ServiceEndpointPropertiesFormatArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpoints = mapped
    }

    /**
     * @param argument An array of service endpoints.
     */
    @JvmName("uiprgpowgoadhoqy")
    public suspend fun serviceEndpoints(
        vararg
        argument: suspend ServiceEndpointPropertiesFormatArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpoints = mapped
    }

    /**
     * @param argument An array of service endpoints.
     */
    @JvmName("hogkgcyacctwsuym")
    public suspend
    fun serviceEndpoints(argument: suspend ServiceEndpointPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceEndpointPropertiesFormatArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serviceEndpoints = mapped
    }

    /**
     * @param values An array of service endpoints.
     */
    @JvmName("sncqpgpxaespfmsq")
    public suspend fun serviceEndpoints(vararg values: ServiceEndpointPropertiesFormatArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceEndpoints = mapped
    }

    /**
     * @param value Resource type.
     */
    @JvmName("hgoxpgsvfucmhdeb")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SubnetArgs = SubnetArgs(
        addressPrefix = addressPrefix,
        addressPrefixes = addressPrefixes,
        applicationGatewayIPConfigurations = applicationGatewayIPConfigurations,
        delegations = delegations,
        etag = etag,
        id = id,
        ipAllocations = ipAllocations,
        name = name,
        natGateway = natGateway,
        networkSecurityGroup = networkSecurityGroup,
        privateEndpointNetworkPolicies = privateEndpointNetworkPolicies,
        privateLinkServiceNetworkPolicies = privateLinkServiceNetworkPolicies,
        provisioningState = provisioningState,
        resourceNavigationLinks = resourceNavigationLinks,
        routeTable = routeTable,
        serviceAssociationLinks = serviceAssociationLinks,
        serviceEndpointPolicies = serviceEndpointPolicies,
        serviceEndpoints = serviceEndpoints,
        type = type,
    )
}
