@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualApplianceAdditionalNicPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network Virtual Appliance Additional NIC properties.
 * @property hasPublicIp Flag (true or false) for Intent for Public Ip on additional nic
 * @property name Name of additional nic
 */
public data class VirtualApplianceAdditionalNicPropertiesArgs(
    public val hasPublicIp: Output<Boolean>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualApplianceAdditionalNicPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.VirtualApplianceAdditionalNicPropertiesArgs =
        com.pulumi.azurenative.network.inputs.VirtualApplianceAdditionalNicPropertiesArgs.builder()
            .hasPublicIp(hasPublicIp?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualApplianceAdditionalNicPropertiesArgs].
 */
@PulumiTagMarker
public class VirtualApplianceAdditionalNicPropertiesArgsBuilder internal constructor() {
    private var hasPublicIp: Output<Boolean>? = null

    private var name: Output<String>? = null

    /**
     * @param value Flag (true or false) for Intent for Public Ip on additional nic
     */
    @JvmName("matbgcmwbxiaftno")
    public suspend fun hasPublicIp(`value`: Output<Boolean>) {
        this.hasPublicIp = value
    }

    /**
     * @param value Name of additional nic
     */
    @JvmName("hmkqcjngnhguxsqh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Flag (true or false) for Intent for Public Ip on additional nic
     */
    @JvmName("jxwrbruafpgmfxlf")
    public suspend fun hasPublicIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hasPublicIp = mapped
    }

    /**
     * @param value Name of additional nic
     */
    @JvmName("jcumguyawnvknylu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): VirtualApplianceAdditionalNicPropertiesArgs =
        VirtualApplianceAdditionalNicPropertiesArgs(
            hasPublicIp = hasPublicIp,
            name = name,
        )
}
