@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualApplianceSkuPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network Virtual Appliance Sku Properties.
 * @property bundledScaleUnit Virtual Appliance Scale Unit.
 * @property marketPlaceVersion Virtual Appliance Version.
 * @property vendor Virtual Appliance Vendor.
 */
public data class VirtualApplianceSkuPropertiesArgs(
    public val bundledScaleUnit: Output<String>? = null,
    public val marketPlaceVersion: Output<String>? = null,
    public val vendor: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualApplianceSkuPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualApplianceSkuPropertiesArgs =
        com.pulumi.azurenative.network.inputs.VirtualApplianceSkuPropertiesArgs.builder()
            .bundledScaleUnit(bundledScaleUnit?.applyValue({ args0 -> args0 }))
            .marketPlaceVersion(marketPlaceVersion?.applyValue({ args0 -> args0 }))
            .vendor(vendor?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualApplianceSkuPropertiesArgs].
 */
@PulumiTagMarker
public class VirtualApplianceSkuPropertiesArgsBuilder internal constructor() {
    private var bundledScaleUnit: Output<String>? = null

    private var marketPlaceVersion: Output<String>? = null

    private var vendor: Output<String>? = null

    /**
     * @param value Virtual Appliance Scale Unit.
     */
    @JvmName("xtxxxrsrmgmjorne")
    public suspend fun bundledScaleUnit(`value`: Output<String>) {
        this.bundledScaleUnit = value
    }

    /**
     * @param value Virtual Appliance Version.
     */
    @JvmName("ojvludfdrytlasrf")
    public suspend fun marketPlaceVersion(`value`: Output<String>) {
        this.marketPlaceVersion = value
    }

    /**
     * @param value Virtual Appliance Vendor.
     */
    @JvmName("arhixudedtxaknpl")
    public suspend fun vendor(`value`: Output<String>) {
        this.vendor = value
    }

    /**
     * @param value Virtual Appliance Scale Unit.
     */
    @JvmName("ltspwbxcddceidds")
    public suspend fun bundledScaleUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bundledScaleUnit = mapped
    }

    /**
     * @param value Virtual Appliance Version.
     */
    @JvmName("ekqrfinfsjlermln")
    public suspend fun marketPlaceVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketPlaceVersion = mapped
    }

    /**
     * @param value Virtual Appliance Vendor.
     */
    @JvmName("dvjgbfotfbmldpuq")
    public suspend fun vendor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vendor = mapped
    }

    internal fun build(): VirtualApplianceSkuPropertiesArgs = VirtualApplianceSkuPropertiesArgs(
        bundledScaleUnit = bundledScaleUnit,
        marketPlaceVersion = marketPlaceVersion,
        vendor = vendor,
    )
}
