@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualNetworkBgpCommunitiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.
 * @property virtualNetworkCommunity The BGP community associated with the virtual network.
 */
public data class VirtualNetworkBgpCommunitiesArgs(
    public val virtualNetworkCommunity: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualNetworkBgpCommunitiesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualNetworkBgpCommunitiesArgs =
        com.pulumi.azurenative.network.inputs.VirtualNetworkBgpCommunitiesArgs.builder()
            .virtualNetworkCommunity(virtualNetworkCommunity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkBgpCommunitiesArgs].
 */
@PulumiTagMarker
public class VirtualNetworkBgpCommunitiesArgsBuilder internal constructor() {
    private var virtualNetworkCommunity: Output<String>? = null

    /**
     * @param value The BGP community associated with the virtual network.
     */
    @JvmName("uusaudmtmrkcmjtv")
    public suspend fun virtualNetworkCommunity(`value`: Output<String>) {
        this.virtualNetworkCommunity = value
    }

    /**
     * @param value The BGP community associated with the virtual network.
     */
    @JvmName("gmfsrevgbtxbagxr")
    public suspend fun virtualNetworkCommunity(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkCommunity = mapped
    }

    internal fun build(): VirtualNetworkBgpCommunitiesArgs = VirtualNetworkBgpCommunitiesArgs(
        virtualNetworkCommunity = virtualNetworkCommunity ?: throw
            PulumiNullFieldException("virtualNetworkCommunity"),
    )
}
