@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualNetworkTapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Virtual Network Tap resource.
 * @property destinationLoadBalancerFrontEndIPConfiguration The reference to the private IP address on the internal Load Balancer that will receive the tap.
 * @property destinationNetworkInterfaceIPConfiguration The reference to the private IP Address of the collector nic that will receive the tap.
 * @property destinationPort The VXLAN destination port that will receive the tapped traffic.
 * @property id Resource ID.
 * @property location Resource location.
 * @property tags Resource tags.
 */
public data class VirtualNetworkTapArgs(
    public val destinationLoadBalancerFrontEndIPConfiguration: Output<FrontendIPConfigurationArgs>? =
        null,
    public val destinationNetworkInterfaceIPConfiguration:
    Output<NetworkInterfaceIPConfigurationArgs>? = null,
    public val destinationPort: Output<Int>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualNetworkTapArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualNetworkTapArgs =
        com.pulumi.azurenative.network.inputs.VirtualNetworkTapArgs.builder()
            .destinationLoadBalancerFrontEndIPConfiguration(
                destinationLoadBalancerFrontEndIPConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .destinationNetworkInterfaceIPConfiguration(
                destinationNetworkInterfaceIPConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .destinationPort(destinationPort?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworkTapArgs].
 */
@PulumiTagMarker
public class VirtualNetworkTapArgsBuilder internal constructor() {
    private var destinationLoadBalancerFrontEndIPConfiguration: Output<FrontendIPConfigurationArgs>? =
        null

    private var destinationNetworkInterfaceIPConfiguration:
        Output<NetworkInterfaceIPConfigurationArgs>? = null

    private var destinationPort: Output<Int>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The reference to the private IP address on the internal Load Balancer that will receive the tap.
     */
    @JvmName("nvdvqfdagwqehgvq")
    public suspend
    fun destinationLoadBalancerFrontEndIPConfiguration(`value`: Output<FrontendIPConfigurationArgs>) {
        this.destinationLoadBalancerFrontEndIPConfiguration = value
    }

    /**
     * @param value The reference to the private IP Address of the collector nic that will receive the tap.
     */
    @JvmName("jmkddfuitfoksggr")
    public suspend
    fun destinationNetworkInterfaceIPConfiguration(`value`: Output<NetworkInterfaceIPConfigurationArgs>) {
        this.destinationNetworkInterfaceIPConfiguration = value
    }

    /**
     * @param value The VXLAN destination port that will receive the tapped traffic.
     */
    @JvmName("ticfcralvdoebjpn")
    public suspend fun destinationPort(`value`: Output<Int>) {
        this.destinationPort = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("tibejpcfryqpuika")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("hynmbnwuytcjmbja")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xolkduwrlyakkuvq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The reference to the private IP address on the internal Load Balancer that will receive the tap.
     */
    @JvmName("muihanybfylbehwf")
    public suspend
    fun destinationLoadBalancerFrontEndIPConfiguration(`value`: FrontendIPConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationLoadBalancerFrontEndIPConfiguration = mapped
    }

    /**
     * @param argument The reference to the private IP address on the internal Load Balancer that will receive the tap.
     */
    @JvmName("bsohtetvsgkerdkj")
    public suspend
    fun destinationLoadBalancerFrontEndIPConfiguration(argument: suspend FrontendIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FrontendIPConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destinationLoadBalancerFrontEndIPConfiguration = mapped
    }

    /**
     * @param value The reference to the private IP Address of the collector nic that will receive the tap.
     */
    @JvmName("bokfwfcprxmcqrht")
    public suspend
    fun destinationNetworkInterfaceIPConfiguration(`value`: NetworkInterfaceIPConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationNetworkInterfaceIPConfiguration = mapped
    }

    /**
     * @param argument The reference to the private IP Address of the collector nic that will receive the tap.
     */
    @JvmName("fposyikklyqojqxx")
    public suspend
    fun destinationNetworkInterfaceIPConfiguration(argument: suspend NetworkInterfaceIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkInterfaceIPConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destinationNetworkInterfaceIPConfiguration = mapped
    }

    /**
     * @param value The VXLAN destination port that will receive the tapped traffic.
     */
    @JvmName("bkxniijrixgwdklx")
    public suspend fun destinationPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPort = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("kdxuktgmssitivtt")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("poytynvkplnctscr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qdenqmdlepmlpuwe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jcskmrqhtvvwvfwd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VirtualNetworkTapArgs = VirtualNetworkTapArgs(
        destinationLoadBalancerFrontEndIPConfiguration = destinationLoadBalancerFrontEndIPConfiguration,
        destinationNetworkInterfaceIPConfiguration = destinationNetworkInterfaceIPConfiguration,
        destinationPort = destinationPort,
        id = id,
        location = location,
        tags = tags,
    )
}
