@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VngClientConnectionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A vpn client connection configuration for client connection configuration.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property virtualNetworkGatewayPolicyGroups List of references to virtualNetworkGatewayPolicyGroups
 * @property vpnClientAddressPool The reference to the address space resource which represents Address space for P2S VpnClient.
 */
public data class VngClientConnectionConfigurationArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val virtualNetworkGatewayPolicyGroups: Output<List<SubResourceArgs>>,
    public val vpnClientAddressPool: Output<AddressSpaceArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VngClientConnectionConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VngClientConnectionConfigurationArgs =
        com.pulumi.azurenative.network.inputs.VngClientConnectionConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .virtualNetworkGatewayPolicyGroups(
                virtualNetworkGatewayPolicyGroups.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnClientAddressPool(
                vpnClientAddressPool.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VngClientConnectionConfigurationArgs].
 */
@PulumiTagMarker
public class VngClientConnectionConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var virtualNetworkGatewayPolicyGroups: Output<List<SubResourceArgs>>? = null

    private var vpnClientAddressPool: Output<AddressSpaceArgs>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("kguptpeylcyudrer")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("ytjlejjprvefuybw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of references to virtualNetworkGatewayPolicyGroups
     */
    @JvmName("sonabkdexhkwchor")
    public suspend fun virtualNetworkGatewayPolicyGroups(`value`: Output<List<SubResourceArgs>>) {
        this.virtualNetworkGatewayPolicyGroups = value
    }

    @JvmName("qggjeyoepoxxdrhb")
    public suspend fun virtualNetworkGatewayPolicyGroups(vararg values: Output<SubResourceArgs>) {
        this.virtualNetworkGatewayPolicyGroups = Output.all(values.asList())
    }

    /**
     * @param values List of references to virtualNetworkGatewayPolicyGroups
     */
    @JvmName("srkdaajdxqxlpufx")
    public suspend fun virtualNetworkGatewayPolicyGroups(values: List<Output<SubResourceArgs>>) {
        this.virtualNetworkGatewayPolicyGroups = Output.all(values)
    }

    /**
     * @param value The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("mqpcsqgpogwxuqqt")
    public suspend fun vpnClientAddressPool(`value`: Output<AddressSpaceArgs>) {
        this.vpnClientAddressPool = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("apsckgcgcajidhlk")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("xypkyiqpnwgqsoqo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of references to virtualNetworkGatewayPolicyGroups
     */
    @JvmName("bmqqdofulwhkmvng")
    public suspend fun virtualNetworkGatewayPolicyGroups(`value`: List<SubResourceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param argument List of references to virtualNetworkGatewayPolicyGroups
     */
    @JvmName("cjyjnsdjkyyparxo")
    public suspend
    fun virtualNetworkGatewayPolicyGroups(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param argument List of references to virtualNetworkGatewayPolicyGroups
     */
    @JvmName("yhwoykykiumcbfbi")
    public suspend fun virtualNetworkGatewayPolicyGroups(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param argument List of references to virtualNetworkGatewayPolicyGroups
     */
    @JvmName("mdsbkchfjdxpiysf")
    public suspend
    fun virtualNetworkGatewayPolicyGroups(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param values List of references to virtualNetworkGatewayPolicyGroups
     */
    @JvmName("jiorelgpcdpvuhoo")
    public suspend fun virtualNetworkGatewayPolicyGroups(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param value The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("lfudbkouemssqjxo")
    public suspend fun vpnClientAddressPool(`value`: AddressSpaceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientAddressPool = mapped
    }

    /**
     * @param argument The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("nfmaahugsaymgrbv")
    public suspend fun vpnClientAddressPool(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpnClientAddressPool = mapped
    }

    internal fun build(): VngClientConnectionConfigurationArgs = VngClientConnectionConfigurationArgs(
        id = id,
        name = name,
        virtualNetworkGatewayPolicyGroups = virtualNetworkGatewayPolicyGroups ?: throw
            PulumiNullFieldException("virtualNetworkGatewayPolicyGroups"),
        vpnClientAddressPool = vpnClientAddressPool ?: throw
            PulumiNullFieldException("vpnClientAddressPool"),
    )
}
