@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnClientConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VpnAuthenticationType
import com.pulumi.azurenative.network.kotlin.enums.VpnClientProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VpnClientConfiguration for P2S client.
 * @property aadAudience The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
 * @property aadIssuer The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
 * @property aadTenant The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
 * @property radiusServerAddress The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
 * @property radiusServerSecret The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
 * @property radiusServers The radiusServers property for multiple radius server configuration.
 * @property vngClientConnectionConfigurations per ip address pool connection policy for virtual network gateway P2S client.
 * @property vpnAuthenticationTypes VPN authentication types for the virtual network gateway..
 * @property vpnClientAddressPool The reference to the address space resource which represents Address space for P2S VpnClient.
 * @property vpnClientIpsecPolicies VpnClientIpsecPolicies for virtual network gateway P2S client.
 * @property vpnClientProtocols VpnClientProtocols for Virtual network gateway.
 * @property vpnClientRevokedCertificates VpnClientRevokedCertificate for Virtual network gateway.
 * @property vpnClientRootCertificates VpnClientRootCertificate for virtual network gateway.
 */
public data class VpnClientConfigurationArgs(
    public val aadAudience: Output<String>? = null,
    public val aadIssuer: Output<String>? = null,
    public val aadTenant: Output<String>? = null,
    public val radiusServerAddress: Output<String>? = null,
    public val radiusServerSecret: Output<String>? = null,
    public val radiusServers: Output<List<RadiusServerArgs>>? = null,
    public val vngClientConnectionConfigurations: Output<List<VngClientConnectionConfigurationArgs>>? =
        null,
    public val vpnAuthenticationTypes: Output<List<Either<String, VpnAuthenticationType>>>? = null,
    public val vpnClientAddressPool: Output<AddressSpaceArgs>? = null,
    public val vpnClientIpsecPolicies: Output<List<IpsecPolicyArgs>>? = null,
    public val vpnClientProtocols: Output<List<Either<String, VpnClientProtocol>>>? = null,
    public val vpnClientRevokedCertificates: Output<List<VpnClientRevokedCertificateArgs>>? = null,
    public val vpnClientRootCertificates: Output<List<VpnClientRootCertificateArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnClientConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VpnClientConfigurationArgs =
        com.pulumi.azurenative.network.inputs.VpnClientConfigurationArgs.builder()
            .aadAudience(aadAudience?.applyValue({ args0 -> args0 }))
            .aadIssuer(aadIssuer?.applyValue({ args0 -> args0 }))
            .aadTenant(aadTenant?.applyValue({ args0 -> args0 }))
            .radiusServerAddress(radiusServerAddress?.applyValue({ args0 -> args0 }))
            .radiusServerSecret(radiusServerSecret?.applyValue({ args0 -> args0 }))
            .radiusServers(
                radiusServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vngClientConnectionConfigurations(
                vngClientConnectionConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnAuthenticationTypes(
                vpnAuthenticationTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .vpnClientAddressPool(
                vpnClientAddressPool?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vpnClientIpsecPolicies(
                vpnClientIpsecPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vpnClientProtocols(
                vpnClientProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .vpnClientRevokedCertificates(
                vpnClientRevokedCertificates?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnClientRootCertificates(
                vpnClientRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VpnClientConfigurationArgs].
 */
@PulumiTagMarker
public class VpnClientConfigurationArgsBuilder internal constructor() {
    private var aadAudience: Output<String>? = null

    private var aadIssuer: Output<String>? = null

    private var aadTenant: Output<String>? = null

    private var radiusServerAddress: Output<String>? = null

    private var radiusServerSecret: Output<String>? = null

    private var radiusServers: Output<List<RadiusServerArgs>>? = null

    private var vngClientConnectionConfigurations: Output<List<VngClientConnectionConfigurationArgs>>? =
        null

    private var vpnAuthenticationTypes: Output<List<Either<String, VpnAuthenticationType>>>? = null

    private var vpnClientAddressPool: Output<AddressSpaceArgs>? = null

    private var vpnClientIpsecPolicies: Output<List<IpsecPolicyArgs>>? = null

    private var vpnClientProtocols: Output<List<Either<String, VpnClientProtocol>>>? = null

    private var vpnClientRevokedCertificates: Output<List<VpnClientRevokedCertificateArgs>>? = null

    private var vpnClientRootCertificates: Output<List<VpnClientRootCertificateArgs>>? = null

    /**
     * @param value The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("rhrxatcxcnggaoob")
    public suspend fun aadAudience(`value`: Output<String>) {
        this.aadAudience = value
    }

    /**
     * @param value The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("ksskjcakjvxlaply")
    public suspend fun aadIssuer(`value`: Output<String>) {
        this.aadIssuer = value
    }

    /**
     * @param value The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("inunwtcywvcwpmiy")
    public suspend fun aadTenant(`value`: Output<String>) {
        this.aadTenant = value
    }

    /**
     * @param value The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
     */
    @JvmName("mbfcsncoegxivjxj")
    public suspend fun radiusServerAddress(`value`: Output<String>) {
        this.radiusServerAddress = value
    }

    /**
     * @param value The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
     */
    @JvmName("ruqdijynaudsbyoq")
    public suspend fun radiusServerSecret(`value`: Output<String>) {
        this.radiusServerSecret = value
    }

    /**
     * @param value The radiusServers property for multiple radius server configuration.
     */
    @JvmName("hayyxkrxyuncuiyu")
    public suspend fun radiusServers(`value`: Output<List<RadiusServerArgs>>) {
        this.radiusServers = value
    }

    @JvmName("bqlujlryjvxxmdxe")
    public suspend fun radiusServers(vararg values: Output<RadiusServerArgs>) {
        this.radiusServers = Output.all(values.asList())
    }

    /**
     * @param values The radiusServers property for multiple radius server configuration.
     */
    @JvmName("gahfuaqpyxbkalrp")
    public suspend fun radiusServers(values: List<Output<RadiusServerArgs>>) {
        this.radiusServers = Output.all(values)
    }

    /**
     * @param value per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("jkythejmglwfdbfi")
    public suspend
    fun vngClientConnectionConfigurations(`value`: Output<List<VngClientConnectionConfigurationArgs>>) {
        this.vngClientConnectionConfigurations = value
    }

    @JvmName("mqyaogcdsiaepmyg")
    public suspend fun vngClientConnectionConfigurations(
        vararg
        values: Output<VngClientConnectionConfigurationArgs>,
    ) {
        this.vngClientConnectionConfigurations = Output.all(values.asList())
    }

    /**
     * @param values per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("pvxrejaglratulfm")
    public suspend
    fun vngClientConnectionConfigurations(values: List<Output<VngClientConnectionConfigurationArgs>>) {
        this.vngClientConnectionConfigurations = Output.all(values)
    }

    /**
     * @param value VPN authentication types for the virtual network gateway..
     */
    @JvmName("yxyruxgtkdwhrshb")
    public suspend
    fun vpnAuthenticationTypes(`value`: Output<List<Either<String, VpnAuthenticationType>>>) {
        this.vpnAuthenticationTypes = value
    }

    @JvmName("lvanqbtoxveynsyr")
    public suspend fun vpnAuthenticationTypes(
        vararg
        values: Output<Either<String, VpnAuthenticationType>>,
    ) {
        this.vpnAuthenticationTypes = Output.all(values.asList())
    }

    /**
     * @param values VPN authentication types for the virtual network gateway..
     */
    @JvmName("wenciqlmrgtgtsbr")
    public suspend
    fun vpnAuthenticationTypes(values: List<Output<Either<String, VpnAuthenticationType>>>) {
        this.vpnAuthenticationTypes = Output.all(values)
    }

    /**
     * @param value The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("vlpsgjvunyqgelqo")
    public suspend fun vpnClientAddressPool(`value`: Output<AddressSpaceArgs>) {
        this.vpnClientAddressPool = value
    }

    /**
     * @param value VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("dnmcajxbccrqagoh")
    public suspend fun vpnClientIpsecPolicies(`value`: Output<List<IpsecPolicyArgs>>) {
        this.vpnClientIpsecPolicies = value
    }

    @JvmName("ydamhpeeiuqiqsvi")
    public suspend fun vpnClientIpsecPolicies(vararg values: Output<IpsecPolicyArgs>) {
        this.vpnClientIpsecPolicies = Output.all(values.asList())
    }

    /**
     * @param values VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("tfwxqklbceladomn")
    public suspend fun vpnClientIpsecPolicies(values: List<Output<IpsecPolicyArgs>>) {
        this.vpnClientIpsecPolicies = Output.all(values)
    }

    /**
     * @param value VpnClientProtocols for Virtual network gateway.
     */
    @JvmName("ujeymcfhfgjglpln")
    public suspend fun vpnClientProtocols(`value`: Output<List<Either<String, VpnClientProtocol>>>) {
        this.vpnClientProtocols = value
    }

    @JvmName("bvconkfdjgpnhbxv")
    public suspend fun vpnClientProtocols(vararg values: Output<Either<String, VpnClientProtocol>>) {
        this.vpnClientProtocols = Output.all(values.asList())
    }

    /**
     * @param values VpnClientProtocols for Virtual network gateway.
     */
    @JvmName("aanatjfhphowneqi")
    public suspend fun vpnClientProtocols(values: List<Output<Either<String, VpnClientProtocol>>>) {
        this.vpnClientProtocols = Output.all(values)
    }

    /**
     * @param value VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("qswdxabihsavblqa")
    public suspend
    fun vpnClientRevokedCertificates(`value`: Output<List<VpnClientRevokedCertificateArgs>>) {
        this.vpnClientRevokedCertificates = value
    }

    @JvmName("rtpdstcplgbjsafq")
    public suspend fun vpnClientRevokedCertificates(
        vararg
        values: Output<VpnClientRevokedCertificateArgs>,
    ) {
        this.vpnClientRevokedCertificates = Output.all(values.asList())
    }

    /**
     * @param values VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("rlkiomiapwyumcku")
    public suspend
    fun vpnClientRevokedCertificates(values: List<Output<VpnClientRevokedCertificateArgs>>) {
        this.vpnClientRevokedCertificates = Output.all(values)
    }

    /**
     * @param value VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("vpucktoorfjkrfpc")
    public suspend
    fun vpnClientRootCertificates(`value`: Output<List<VpnClientRootCertificateArgs>>) {
        this.vpnClientRootCertificates = value
    }

    @JvmName("jqobjttcocpaaylk")
    public suspend fun vpnClientRootCertificates(
        vararg
        values: Output<VpnClientRootCertificateArgs>,
    ) {
        this.vpnClientRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("fbnqmfxvngfbiaev")
    public suspend fun vpnClientRootCertificates(values: List<Output<VpnClientRootCertificateArgs>>) {
        this.vpnClientRootCertificates = Output.all(values)
    }

    /**
     * @param value The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("aptvcbbwqoovycsd")
    public suspend fun aadAudience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadAudience = mapped
    }

    /**
     * @param value The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("hgdaaxxwwfjuyigp")
    public suspend fun aadIssuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadIssuer = mapped
    }

    /**
     * @param value The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("dluvvsfixfbuqmhu")
    public suspend fun aadTenant(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadTenant = mapped
    }

    /**
     * @param value The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
     */
    @JvmName("yckbtswnbjoyjrlb")
    public suspend fun radiusServerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerAddress = mapped
    }

    /**
     * @param value The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
     */
    @JvmName("hxhcgttgeciprrwq")
    public suspend fun radiusServerSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerSecret = mapped
    }

    /**
     * @param value The radiusServers property for multiple radius server configuration.
     */
    @JvmName("pbywnqucsvjnoome")
    public suspend fun radiusServers(`value`: List<RadiusServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServers = mapped
    }

    /**
     * @param argument The radiusServers property for multiple radius server configuration.
     */
    @JvmName("fhiinqdfnsrxtgqe")
    public suspend fun radiusServers(argument: List<suspend RadiusServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RadiusServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param argument The radiusServers property for multiple radius server configuration.
     */
    @JvmName("sjfqriffihmwfqra")
    public suspend fun radiusServers(vararg argument: suspend RadiusServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RadiusServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param argument The radiusServers property for multiple radius server configuration.
     */
    @JvmName("aesjhjufoclbyigj")
    public suspend fun radiusServers(argument: suspend RadiusServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RadiusServerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param values The radiusServers property for multiple radius server configuration.
     */
    @JvmName("xtileuygqnoantkh")
    public suspend fun radiusServers(vararg values: RadiusServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.radiusServers = mapped
    }

    /**
     * @param value per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("wukpdnpnbanncnhs")
    public suspend
    fun vngClientConnectionConfigurations(`value`: List<VngClientConnectionConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param argument per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("sanpwqwkgxphajwv")
    public suspend
    fun vngClientConnectionConfigurations(argument: List<suspend VngClientConnectionConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VngClientConnectionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param argument per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("wtiewdjmryjkdcbe")
    public suspend fun vngClientConnectionConfigurations(
        vararg
        argument: suspend VngClientConnectionConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VngClientConnectionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param argument per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("bgwalcdisyppnpue")
    public suspend
    fun vngClientConnectionConfigurations(argument: suspend VngClientConnectionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VngClientConnectionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param values per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("eeggkfdjqhnbrpcr")
    public suspend fun vngClientConnectionConfigurations(
        vararg
        values: VngClientConnectionConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param value VPN authentication types for the virtual network gateway..
     */
    @JvmName("rtwgjmnoqridjuln")
    public suspend fun vpnAuthenticationTypes(`value`: List<Either<String, VpnAuthenticationType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnAuthenticationTypes = mapped
    }

    /**
     * @param values VPN authentication types for the virtual network gateway..
     */
    @JvmName("lvcodhlyrvrgjokv")
    public suspend fun vpnAuthenticationTypes(vararg values: Either<String, VpnAuthenticationType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnAuthenticationTypes = mapped
    }

    /**
     * @param value The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("afqudpemcqsabtai")
    public suspend fun vpnClientAddressPool(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientAddressPool = mapped
    }

    /**
     * @param argument The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("slfovvsaqvathxbt")
    public suspend fun vpnClientAddressPool(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpnClientAddressPool = mapped
    }

    /**
     * @param value VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("edfgsdiabbkvvnov")
    public suspend fun vpnClientIpsecPolicies(`value`: List<IpsecPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("lrhtgsttmpcseyca")
    public suspend
    fun vpnClientIpsecPolicies(argument: List<suspend IpsecPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("vmlcxeevxiilpfgm")
    public suspend fun vpnClientIpsecPolicies(
        vararg
        argument: suspend IpsecPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("ekqlqgidkwwjeaao")
    public suspend fun vpnClientIpsecPolicies(argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpsecPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param values VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("tspdvtawmrgjxdhw")
    public suspend fun vpnClientIpsecPolicies(vararg values: IpsecPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param value VpnClientProtocols for Virtual network gateway.
     */
    @JvmName("uomofbluuaiysjfw")
    public suspend fun vpnClientProtocols(`value`: List<Either<String, VpnClientProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientProtocols = mapped
    }

    /**
     * @param values VpnClientProtocols for Virtual network gateway.
     */
    @JvmName("uayhtdbikgulcnox")
    public suspend fun vpnClientProtocols(vararg values: Either<String, VpnClientProtocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientProtocols = mapped
    }

    /**
     * @param value VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("dvqulhmygdwooxib")
    public suspend fun vpnClientRevokedCertificates(`value`: List<VpnClientRevokedCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("kqrdnlpwiumrljdc")
    public suspend
    fun vpnClientRevokedCertificates(argument: List<suspend VpnClientRevokedCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnClientRevokedCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("khmwmdrvgaspqijm")
    public suspend fun vpnClientRevokedCertificates(
        vararg
        argument: suspend VpnClientRevokedCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnClientRevokedCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("dulabvcvqlaqawoa")
    public suspend
    fun vpnClientRevokedCertificates(argument: suspend VpnClientRevokedCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnClientRevokedCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param values VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("kptnbuakkeelqvnn")
    public suspend fun vpnClientRevokedCertificates(vararg values: VpnClientRevokedCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param value VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("brrtsaphaylxmhpv")
    public suspend fun vpnClientRootCertificates(`value`: List<VpnClientRootCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("cplffoeaufjylhib")
    public suspend
    fun vpnClientRootCertificates(argument: List<suspend VpnClientRootCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnClientRootCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("wgvhntupgaugjmtr")
    public suspend fun vpnClientRootCertificates(
        vararg
        argument: suspend VpnClientRootCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnClientRootCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("kycxylsxngcxgjia")
    public suspend
    fun vpnClientRootCertificates(argument: suspend VpnClientRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnClientRootCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param values VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("xjukffblmodcdmmc")
    public suspend fun vpnClientRootCertificates(vararg values: VpnClientRootCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientRootCertificates = mapped
    }

    internal fun build(): VpnClientConfigurationArgs = VpnClientConfigurationArgs(
        aadAudience = aadAudience,
        aadIssuer = aadIssuer,
        aadTenant = aadTenant,
        radiusServerAddress = radiusServerAddress,
        radiusServerSecret = radiusServerSecret,
        radiusServers = radiusServers,
        vngClientConnectionConfigurations = vngClientConnectionConfigurations,
        vpnAuthenticationTypes = vpnAuthenticationTypes,
        vpnClientAddressPool = vpnClientAddressPool,
        vpnClientIpsecPolicies = vpnClientIpsecPolicies,
        vpnClientProtocols = vpnClientProtocols,
        vpnClientRevokedCertificates = vpnClientRevokedCertificates,
        vpnClientRootCertificates = vpnClientRootCertificates,
    )
}
