@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnClientRevokedCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VPN client revoked certificate of virtual network gateway.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property thumbprint The revoked VPN client certificate thumbprint.
 */
public data class VpnClientRevokedCertificateArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val thumbprint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnClientRevokedCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VpnClientRevokedCertificateArgs =
        com.pulumi.azurenative.network.inputs.VpnClientRevokedCertificateArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .thumbprint(thumbprint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnClientRevokedCertificateArgs].
 */
@PulumiTagMarker
public class VpnClientRevokedCertificateArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var thumbprint: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("drbmlfkuvlbmttdx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("gwofwwlvhoaaason")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The revoked VPN client certificate thumbprint.
     */
    @JvmName("uqnimbcwvgtwtbgj")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("cgslptsvuxjslhnf")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("qnjkudefsmpfxfan")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The revoked VPN client certificate thumbprint.
     */
    @JvmName("wsbdcgbkonbxrxxd")
    public suspend fun thumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    internal fun build(): VpnClientRevokedCertificateArgs = VpnClientRevokedCertificateArgs(
        id = id,
        name = name,
        thumbprint = thumbprint,
    )
}
