@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnClientRootCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VPN client root certificate of virtual network gateway.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property publicCertData The certificate public data.
 */
public data class VpnClientRootCertificateArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val publicCertData: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnClientRootCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VpnClientRootCertificateArgs =
        com.pulumi.azurenative.network.inputs.VpnClientRootCertificateArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .publicCertData(publicCertData.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnClientRootCertificateArgs].
 */
@PulumiTagMarker
public class VpnClientRootCertificateArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var publicCertData: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("ebgnycqbcfyjpgac")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("oayxyiavtweuejys")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The certificate public data.
     */
    @JvmName("wdycacxgetrymhgf")
    public suspend fun publicCertData(`value`: Output<String>) {
        this.publicCertData = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("vhquvmljjrtrgyvl")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("lbudbctqnogenhsr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The certificate public data.
     */
    @JvmName("mbirfqcwxkyxurej")
    public suspend fun publicCertData(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicCertData = mapped
    }

    internal fun build(): VpnClientRootCertificateArgs = VpnClientRootCertificateArgs(
        id = id,
        name = name,
        publicCertData = publicCertData ?: throw PulumiNullFieldException("publicCertData"),
    )
}
