@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnNatRuleMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Vpn NatRule mapping.
 * @property addressSpace Address space for Vpn NatRule mapping.
 * @property portRange Port range for Vpn NatRule mapping.
 */
public data class VpnNatRuleMappingArgs(
    public val addressSpace: Output<String>? = null,
    public val portRange: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnNatRuleMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VpnNatRuleMappingArgs =
        com.pulumi.azurenative.network.inputs.VpnNatRuleMappingArgs.builder()
            .addressSpace(addressSpace?.applyValue({ args0 -> args0 }))
            .portRange(portRange?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnNatRuleMappingArgs].
 */
@PulumiTagMarker
public class VpnNatRuleMappingArgsBuilder internal constructor() {
    private var addressSpace: Output<String>? = null

    private var portRange: Output<String>? = null

    /**
     * @param value Address space for Vpn NatRule mapping.
     */
    @JvmName("wrpooqqcuouemnss")
    public suspend fun addressSpace(`value`: Output<String>) {
        this.addressSpace = value
    }

    /**
     * @param value Port range for Vpn NatRule mapping.
     */
    @JvmName("tsmxqxdluuhvmcue")
    public suspend fun portRange(`value`: Output<String>) {
        this.portRange = value
    }

    /**
     * @param value Address space for Vpn NatRule mapping.
     */
    @JvmName("qedlcfvtvicyknlv")
    public suspend fun addressSpace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressSpace = mapped
    }

    /**
     * @param value Port range for Vpn NatRule mapping.
     */
    @JvmName("xcnqoudakqarckfs")
    public suspend fun portRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portRange = mapped
    }

    internal fun build(): VpnNatRuleMappingArgs = VpnNatRuleMappingArgs(
        addressSpace = addressSpace,
        portRange = portRange,
    )
}
