@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnServerConfigRadiusClientRootCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the Radius client root certificate of VpnServerConfiguration.
 * @property name The certificate name.
 * @property thumbprint The Radius client root certificate thumbprint.
 */
public data class VpnServerConfigRadiusClientRootCertificateArgs(
    public val name: Output<String>? = null,
    public val thumbprint: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnServerConfigRadiusClientRootCertificateArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.VpnServerConfigRadiusClientRootCertificateArgs =
        com.pulumi.azurenative.network.inputs.VpnServerConfigRadiusClientRootCertificateArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .thumbprint(thumbprint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnServerConfigRadiusClientRootCertificateArgs].
 */
@PulumiTagMarker
public class VpnServerConfigRadiusClientRootCertificateArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var thumbprint: Output<String>? = null

    /**
     * @param value The certificate name.
     */
    @JvmName("yydegoncwntbwksa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Radius client root certificate thumbprint.
     */
    @JvmName("nvvfruvrrgwextmc")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value The certificate name.
     */
    @JvmName("wjqwxwottoleggjb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Radius client root certificate thumbprint.
     */
    @JvmName("coasakdnohvtsgsf")
    public suspend fun thumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    internal fun build(): VpnServerConfigRadiusClientRootCertificateArgs =
        VpnServerConfigRadiusClientRootCertificateArgs(
            name = name,
            thumbprint = thumbprint,
        )
}
