@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnServerConfigRadiusServerRootCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of Radius Server root certificate of VpnServerConfiguration.
 * @property name The certificate name.
 * @property publicCertData The certificate public data.
 */
public data class VpnServerConfigRadiusServerRootCertificateArgs(
    public val name: Output<String>? = null,
    public val publicCertData: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnServerConfigRadiusServerRootCertificateArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.VpnServerConfigRadiusServerRootCertificateArgs =
        com.pulumi.azurenative.network.inputs.VpnServerConfigRadiusServerRootCertificateArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .publicCertData(publicCertData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnServerConfigRadiusServerRootCertificateArgs].
 */
@PulumiTagMarker
public class VpnServerConfigRadiusServerRootCertificateArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var publicCertData: Output<String>? = null

    /**
     * @param value The certificate name.
     */
    @JvmName("rveouejefsteiiyh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The certificate public data.
     */
    @JvmName("nybjmmmbrilehvfl")
    public suspend fun publicCertData(`value`: Output<String>) {
        this.publicCertData = value
    }

    /**
     * @param value The certificate name.
     */
    @JvmName("vjnydcoifhmhpdeo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The certificate public data.
     */
    @JvmName("wcqntojyjqbswutl")
    public suspend fun publicCertData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicCertData = mapped
    }

    internal fun build(): VpnServerConfigRadiusServerRootCertificateArgs =
        VpnServerConfigRadiusServerRootCertificateArgs(
            name = name,
            publicCertData = publicCertData,
        )
}
