@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Action to be taken on a route matching a RouteMap criterion.
 * @property parameters List of parameters relevant to the action.For instance if type is drop then parameters has list of prefixes to be dropped.If type is add, parameters would have list of ASN numbers to be added
 * @property type Type of action to be taken. Supported types are 'Remove', 'Add', 'Replace', and 'Drop.'
 */
public data class ActionResponse(
    public val parameters: List<ParameterResponse>? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ActionResponse):
            ActionResponse = ActionResponse(
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ParameterResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
