@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Address prefix item.
 * @property addressPrefix Address prefix.
 * @property addressPrefixType Address prefix type.
 */
public data class AddressPrefixItemResponse(
    public val addressPrefix: String? = null,
    public val addressPrefixType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.AddressPrefixItemResponse):
            AddressPrefixItemResponse = AddressPrefixItemResponse(
            addressPrefix = javaType.addressPrefix().map({ args0 -> args0 }).orElse(null),
            addressPrefixType = javaType.addressPrefixType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
