@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Authentication certificates of an application gateway.
 * @property data Certificate public data.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the authentication certificate that is unique within an Application Gateway.
 * @property provisioningState The provisioning state of the authentication certificate resource.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayAuthenticationCertificateResponse(
    public val `data`: String? = null,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayAuthenticationCertificateResponse):
            ApplicationGatewayAuthenticationCertificateResponse =
            ApplicationGatewayAuthenticationCertificateResponse(
                `data` = javaType.`data`().map({ args0 -> args0 }).orElse(null),
                etag = javaType.etag(),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
                type = javaType.type(),
            )
    }
}
