@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Probe of the application gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property host Host name to send the probe to.
 * @property id Resource ID.
 * @property interval The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
 * @property match Criterion for classifying a healthy probe response.
 * @property minServers Minimum number of servers that are always marked healthy. Default value is 0.
 * @property name Name of the probe that is unique within an Application Gateway.
 * @property path Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
 * @property pickHostNameFromBackendHttpSettings Whether the host header should be picked from the backend http settings. Default value is false.
 * @property pickHostNameFromBackendSettings Whether the server name indication should be picked from the backend settings for Tls protocol. Default value is false.
 * @property port Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set, port from http settings will be used. This property is valid for Standard_v2 and WAF_v2 only.
 * @property protocol The protocol used for the probe.
 * @property provisioningState The provisioning state of the probe resource.
 * @property timeout The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
 * @property type Type of the resource.
 * @property unhealthyThreshold The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
 */
public data class ApplicationGatewayProbeResponse(
    public val etag: String,
    public val host: String? = null,
    public val id: String? = null,
    public val interval: Int? = null,
    public val match: ApplicationGatewayProbeHealthResponseMatchResponse? = null,
    public val minServers: Int? = null,
    public val name: String? = null,
    public val path: String? = null,
    public val pickHostNameFromBackendHttpSettings: Boolean? = null,
    public val pickHostNameFromBackendSettings: Boolean? = null,
    public val port: Int? = null,
    public val protocol: String? = null,
    public val provisioningState: String,
    public val timeout: Int? = null,
    public val type: String,
    public val unhealthyThreshold: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayProbeResponse):
            ApplicationGatewayProbeResponse = ApplicationGatewayProbeResponse(
            etag = javaType.etag(),
            host = javaType.host().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            match = javaType.match().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayProbeHealthResponseMatchResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            minServers = javaType.minServers().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            pickHostNameFromBackendHttpSettings = javaType.pickHostNameFromBackendHttpSettings().map({ args0 ->
                args0
            }).orElse(null),
            pickHostNameFromBackendSettings = javaType.pickHostNameFromBackendSettings().map({ args0 ->
                args0
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            unhealthyThreshold = javaType.unhealthyThreshold().map({ args0 -> args0 }).orElse(null),
        )
    }
}
