@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Set of actions in the Rewrite Rule in Application Gateway.
 * @property requestHeaderConfigurations Request Header Actions in the Action Set.
 * @property responseHeaderConfigurations Response Header Actions in the Action Set.
 * @property urlConfiguration Url Configuration Action in the Action Set.
 */
public data class ApplicationGatewayRewriteRuleActionSetResponse(
    public val requestHeaderConfigurations: List<ApplicationGatewayHeaderConfigurationResponse>? =
        null,
    public val responseHeaderConfigurations: List<ApplicationGatewayHeaderConfigurationResponse>? =
        null,
    public val urlConfiguration: ApplicationGatewayUrlConfigurationResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayRewriteRuleActionSetResponse):
            ApplicationGatewayRewriteRuleActionSetResponse =
            ApplicationGatewayRewriteRuleActionSetResponse(
                requestHeaderConfigurations = javaType.requestHeaderConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayHeaderConfigurationResponse.Companion.toKotlin(args0)
                    })
                }),
                responseHeaderConfigurations = javaType.responseHeaderConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayHeaderConfigurationResponse.Companion.toKotlin(args0)
                    })
                }),
                urlConfiguration = javaType.urlConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayUrlConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
