@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Trusted Root certificates of an application gateway.
 * @property data Certificate public data.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property keyVaultSecretId Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
 * @property name Name of the trusted root certificate that is unique within an Application Gateway.
 * @property provisioningState The provisioning state of the trusted root certificate resource.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayTrustedRootCertificateResponse(
    public val `data`: String? = null,
    public val etag: String,
    public val id: String? = null,
    public val keyVaultSecretId: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayTrustedRootCertificateResponse):
            ApplicationGatewayTrustedRootCertificateResponse =
            ApplicationGatewayTrustedRootCertificateResponse(
                `data` = javaType.`data`().map({ args0 -> args0 }).orElse(null),
                etag = javaType.etag(),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                keyVaultSecretId = javaType.keyVaultSecretId().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
                type = javaType.type(),
            )
    }
}
