@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a NAT rule.
 * @property description Description of the rule.
 * @property destinationAddresses List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
 * @property destinationPorts List of destination ports.
 * @property name Name of the NAT rule.
 * @property protocols Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 * @property translatedAddress The translated address for this NAT rule.
 * @property translatedFqdn The translated FQDN for this NAT rule.
 * @property translatedPort The translated port for this NAT rule.
 */
public data class AzureFirewallNatRuleResponse(
    public val description: String? = null,
    public val destinationAddresses: List<String>? = null,
    public val destinationPorts: List<String>? = null,
    public val name: String? = null,
    public val protocols: List<String>? = null,
    public val sourceAddresses: List<String>? = null,
    public val sourceIpGroups: List<String>? = null,
    public val translatedAddress: String? = null,
    public val translatedFqdn: String? = null,
    public val translatedPort: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.AzureFirewallNatRuleResponse):
            AzureFirewallNatRuleResponse = AzureFirewallNatRuleResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationAddresses = javaType.destinationAddresses().map({ args0 -> args0 }),
            destinationPorts = javaType.destinationPorts().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protocols = javaType.protocols().map({ args0 -> args0 }),
            sourceAddresses = javaType.sourceAddresses().map({ args0 -> args0 }),
            sourceIpGroups = javaType.sourceIpGroups().map({ args0 -> args0 }),
            translatedAddress = javaType.translatedAddress().map({ args0 -> args0 }).orElse(null),
            translatedFqdn = javaType.translatedFqdn().map({ args0 -> args0 }).orElse(null),
            translatedPort = javaType.translatedPort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
