@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of the network rule.
 * @property description Description of the rule.
 * @property destinationAddresses List of destination IP addresses.
 * @property destinationFqdns List of destination FQDNs.
 * @property destinationIpGroups List of destination IpGroups for this rule.
 * @property destinationPorts List of destination ports.
 * @property name Name of the network rule.
 * @property protocols Array of AzureFirewallNetworkRuleProtocols.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 */
public data class AzureFirewallNetworkRuleResponse(
    public val description: String? = null,
    public val destinationAddresses: List<String>? = null,
    public val destinationFqdns: List<String>? = null,
    public val destinationIpGroups: List<String>? = null,
    public val destinationPorts: List<String>? = null,
    public val name: String? = null,
    public val protocols: List<String>? = null,
    public val sourceAddresses: List<String>? = null,
    public val sourceIpGroups: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.AzureFirewallNetworkRuleResponse):
            AzureFirewallNetworkRuleResponse = AzureFirewallNetworkRuleResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationAddresses = javaType.destinationAddresses().map({ args0 -> args0 }),
            destinationFqdns = javaType.destinationFqdns().map({ args0 -> args0 }),
            destinationIpGroups = javaType.destinationIpGroups().map({ args0 -> args0 }),
            destinationPorts = javaType.destinationPorts().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protocols = javaType.protocols().map({ args0 -> args0 }),
            sourceAddresses = javaType.sourceAddresses().map({ args0 -> args0 }),
            sourceIpGroups = javaType.sourceIpGroups().map({ args0 -> args0 }),
        )
    }
}
