@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A CAA record.
 * @property flags The flags for this CAA record as an integer between 0 and 255.
 * @property tag The tag for this CAA record.
 * @property value The value for this CAA record.
 */
public data class CaaRecordResponse(
    public val flags: Int? = null,
    public val tag: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.CaaRecordResponse):
            CaaRecordResponse = CaaRecordResponse(
            flags = javaType.flags().map({ args0 -> args0 }).orElse(null),
            tag = javaType.tag().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
