@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The network configuration group resource
 * @property conditionalMembership Network group conditional filter.
 * @property description A description of the network group.
 * @property displayName A friendly name for the network group.
 * @property groupMembers Group members of network group.
 * @property id Network group ID.
 * @property memberType Group member type.
 * @property provisioningState The provisioning state of the scope assignment resource.
 * @property resourceGuid Unique identifier for this resource.
 */
public data class ConfigurationGroupResponse(
    public val conditionalMembership: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val groupMembers: List<GroupMembersItemResponse>? = null,
    public val id: String? = null,
    public val memberType: String? = null,
    public val provisioningState: String,
    public val resourceGuid: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConfigurationGroupResponse):
            ConfigurationGroupResponse = ConfigurationGroupResponse(
            conditionalMembership = javaType.conditionalMembership().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            groupMembers = javaType.groupMembers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.GroupMembersItemResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            memberType = javaType.memberType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
        )
    }
}
