@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the connection monitor endpoint.
 * @property address Address of the connection monitor endpoint (IP or domain name).
 * @property coverageLevel Test coverage for the endpoint.
 * @property filter Filter for sub-items within the endpoint.
 * @property name The name of the connection monitor endpoint.
 * @property resourceId Resource ID of the connection monitor endpoint.
 * @property scope Endpoint scope.
 * @property type The endpoint type.
 */
public data class ConnectionMonitorEndpointResponse(
    public val address: String? = null,
    public val coverageLevel: String? = null,
    public val filter: ConnectionMonitorEndpointFilterResponse? = null,
    public val name: String,
    public val resourceId: String? = null,
    public val scope: ConnectionMonitorEndpointScopeResponse? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorEndpointResponse):
            ConnectionMonitorEndpointResponse = ConnectionMonitorEndpointResponse(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            coverageLevel = javaType.coverageLevel().map({ args0 -> args0 }).orElse(null),
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorEndpointFilterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorEndpointScopeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
