@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes the source of connection monitor.
 * @property port The source port used by connection monitor.
 * @property resourceId The ID of the resource used as the source by connection monitor.
 */
public data class ConnectionMonitorSourceResponse(
    public val port: Int? = null,
    public val resourceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorSourceResponse):
            ConnectionMonitorSourceResponse = ConnectionMonitorSourceResponse(
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId(),
        )
    }
}
