@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes a connection monitor test configuration.
 * @property httpConfiguration The parameters used to perform test evaluation over HTTP.
 * @property icmpConfiguration The parameters used to perform test evaluation over ICMP.
 * @property name The name of the connection monitor test configuration.
 * @property preferredIPVersion The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters.
 * @property protocol The protocol to use in test evaluation.
 * @property successThreshold The threshold for declaring a test successful.
 * @property tcpConfiguration The parameters used to perform test evaluation over TCP.
 * @property testFrequencySec The frequency of test evaluation, in seconds.
 */
public data class ConnectionMonitorTestConfigurationResponse(
    public val httpConfiguration: ConnectionMonitorHttpConfigurationResponse? = null,
    public val icmpConfiguration: ConnectionMonitorIcmpConfigurationResponse? = null,
    public val name: String,
    public val preferredIPVersion: String? = null,
    public val protocol: String,
    public val successThreshold: ConnectionMonitorSuccessThresholdResponse? = null,
    public val tcpConfiguration: ConnectionMonitorTcpConfigurationResponse? = null,
    public val testFrequencySec: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorTestConfigurationResponse):
            ConnectionMonitorTestConfigurationResponse = ConnectionMonitorTestConfigurationResponse(
            httpConfiguration = javaType.httpConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorHttpConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            icmpConfiguration = javaType.icmpConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorIcmpConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            preferredIPVersion = javaType.preferredIPVersion().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol(),
            successThreshold = javaType.successThreshold().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorSuccessThresholdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tcpConfiguration = javaType.tcpConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorTcpConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            testFrequencySec = javaType.testFrequencySec().map({ args0 -> args0 }).orElse(null),
        )
    }
}
